/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.config;

import com.google.common.base.Strings;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class DateStrToLocalDateTimeConverterConfig
implements Converter<String, LocalDateTime> {
    private String[] patterns = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-ddTHH:mm:ss.SSSZ"};

    public LocalDateTime convert(String dateAsString) {
        if (Strings.isNullOrEmpty((String)dateAsString)) {
            return null;
        }
        Date parseDate = null;
        try {
            parseDate = DateUtils.parseDate((String)dateAsString, (String[])this.patterns);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getCause());
        }
        Instant instant = parseDate.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = instant.atZone(zoneId).toLocalDateTime();
        return localDateTime;
    }
}

