/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.config;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EventBusConfig {
    @Bean
    public EventBus eventBus() {
        int corePoolSize = 8;
        int maximumPoolSize = 180;
        long keepAliveTime = 0L;
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(512);
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("triton-eventbus-pool-%d").setDaemon(true).build();
        ThreadPoolExecutor.AbortPolicy handler = new ThreadPoolExecutor.AbortPolicy();
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, workQueue, namedThreadFactory, handler);
        return new AsyncEventBus((Executor)executorService);
    }
}

