/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.config;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.jingtong.bpm.logic.service.LoginUserHolder;
import com.jingtong.config.MybatisPlusConfig;
import com.jingtong.config.TenantProperties;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Configuration
@AutoConfigureBefore(value={MybatisPlusConfig.class})
@EnableConfigurationProperties(value={TenantProperties.class})
@Component
public class TenantConfig {
    private static final Logger log = LoggerFactory.getLogger(TenantConfig.class);
    private final TenantProperties tenantProperties;
    private final LoginUserHolder loginUserHolder;

    @Bean
    public TenantLineInnerInterceptor tenantLineInnerInterceptor() {
        return new TenantLineInnerInterceptor(new TenantLineHandler(){

            public Expression getTenantId() {
                String tenant = TenantConfig.this.loginUserHolder.getBloc();
                log.info("\u83b7\u53d6\u5230\u4e86\u5e73\u53f0\u7f16\u7801\uff1a{}", (Object)tenant);
                if (tenant != null) {
                    return new StringValue(tenant);
                }
                return new NullValue();
            }

            public String getTenantIdColumn() {
                return TenantConfig.this.tenantProperties.getColumn();
            }

            public boolean ignoreTable(String tableName) {
                return TenantConfig.this.tenantProperties.getIgnoreTables().stream().anyMatch(t -> t.equalsIgnoreCase(tableName));
            }
        });
    }

    public TenantConfig(TenantProperties tenantProperties, LoginUserHolder loginUserHolder) {
        this.tenantProperties = tenantProperties;
        this.loginUserHolder = loginUserHolder;
    }
}

