/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.error;

import cn.hutool.core.collection.CollectionUtil;
import com.google.common.base.Strings;
import com.jingtong.data.exception.ExpiredTokenException;
import com.jingtong.data.exception.PermissionException;
import com.jingtong.data.exception.RbException;
import com.jingtong.data.rest.R;
import com.jingtong.util.error.BasisCode;
import com.jingtong.util.error.ErrorCode;
import com.jingtong.web.Ii8nMessageService;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.activiti.engine.ActivitiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice(annotations={RestController.class})
public class AppExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(AppExceptionHandler.class);
    private final Ii8nMessageService messageService;

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={ActivitiException.class})
    public R handlerActivitiException(ActivitiException e) {
        String msg = e.getMessage();
        return R.error().code((ErrorCode)BasisCode.SERVER_ERROR).message(msg);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={RbException.class})
    public R handleRbException(RbException e) {
        ErrorCode errorCode = e.getCode();
        String msg = e.getMsg();
        if (Strings.isNullOrEmpty((String)msg)) {
            String message = Objects.isNull(e.getParams()) ? this.messageService.getMessage(errorCode) : this.messageService.getMessage(errorCode, e.getParams());
            msg = message;
        }
        return R.error().code(errorCode).message(msg);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={PermissionException.class})
    public R handlePermissionException(PermissionException e) {
        ErrorCode errorCode = e.getCode();
        return R.error().code(errorCode).data(e.getData()).message(e.getMessage());
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={ExpiredTokenException.class})
    public R handleExpiredCredentialsException(ExpiredTokenException e) {
        ErrorCode errorCode = e.getCode();
        return R.error().code(errorCode).message(e.getMsg()).data(Collections.emptyMap());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={SQLException.class})
    public R sqlException(SQLException exception) {
        log.error("sql has exception", (Throwable)exception);
        String message = "sql has exception";
        return R.error().code((ErrorCode)BasisCode.DB_ERROR).message("sql has exception");
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={NoHandlerFoundException.class})
    public R handlerNoFoundException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return R.error().code((ErrorCode)BasisCode.NOT_FOUND);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public R handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return R.error().code((ErrorCode)BasisCode.SERVER_ERROR);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={BindException.class})
    public R bindException(BindException e) {
        log.error("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25\u9519\u8bef!", (Throwable)e);
        return this.validatorException(e.getBindingResult());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public R exception(ConstraintViolationException e) {
        String message = e.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining());
        return R.error().code((ErrorCode)BasisCode.PARAM_VALID).message(message);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public R exception(MethodArgumentNotValidException e) {
        log.error("\u53c2\u6570\u6821\u9a8c\u9519\u8bef!", (Throwable)e);
        return this.validatorException(e.getBindingResult());
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public R exception(MissingServletRequestParameterException e) {
        log.error("", (Throwable)e);
        return R.error().code((ErrorCode)BasisCode.PARAM_VALID).message("\u8bf7\u6c42\u53c2\u6570 " + e.getParameterName() + " \u4e0d\u80fd\u4e3a\u7a7a");
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public R exception(HttpMessageNotReadableException e) {
        log.error("\u53c2\u6570\u6821\u9a8c\u9519\u8bef!", (Throwable)e);
        return R.error().code((ErrorCode)BasisCode.PARAM_VALID).message("\u53c2\u6570\u6821\u9a8c\u5931\u8d25:" + e.getMessage());
    }

    private R validatorException(BindingResult bindingResult) {
        List errorList = bindingResult.getAllErrors();
        String message = "\u53c2\u6570\u9519\u8bef!";
        if (errorList != null) {
            HashMap errMap = new HashMap();
            bindingResult.getFieldErrors().forEach(item -> errMap.put(item.getField(), item.getDefaultMessage()));
            if (CollectionUtil.isNotEmpty((Collection)errorList)) {
                log.error("\u9519\u8bef\u53c2\u6570\u8be6\u60c5\u5982\u4e0b:{}", (Object)errorList);
                return R.error((String)"\u53c2\u6570\u9519\u8bef!").error(errMap).code((ErrorCode)BasisCode.PARAM_VALID);
            }
        }
        return R.error((String)"\u53c2\u6570\u9519\u8bef!").code((ErrorCode)BasisCode.PARAM_VALID);
    }

    public AppExceptionHandler(Ii8nMessageService messageService) {
        this.messageService = messageService;
    }
}

