/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.web;

import com.jingtong.util.error.ErrorCode;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class Ii8nMessageService {
    private final MessageSource messageSource;

    @Autowired
    public Ii8nMessageService(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getMessage(ErrorCode code) {
        return this.getMessage(code.getCode());
    }

    public String getMessage(ErrorCode code, Object[] args) {
        return this.getMessage(code.getCode() + "", args);
    }

    public String getMessage(int code) {
        return this.getMessage(code + "", null);
    }

    public String getMessage(String code) {
        return this.getMessage(code, null);
    }

    public String getMessage(String code, Object[] args) {
        return this.getMessage(code, args, "");
    }

    public String getMessage(String code, Object[] args, String defaultMessage) {
        Locale locale = LocaleContextHolder.getLocale();
        return this.messageSource.getMessage(code, args, defaultMessage, locale);
    }
}

