/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.data.rest;

import com.jingtong.util.datetime.DateTimeUtil;
import com.jingtong.util.error.BasisCode;
import com.jingtong.util.error.ErrorCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.Map;

@ApiModel(value="\u5168\u5c40\u8fd4\u56de\u7ed3\u679c")
public class R<T> {
    @ApiModelProperty(value="\u8fd4\u56de\u7801")
    private int code = BasisCode.SUCESS.getCode();
    @ApiModelProperty(value="\u8fd4\u56de\u6d88\u606f")
    private String msg = "";
    @ApiModelProperty(value="\u8fd4\u56de\u6570\u636e")
    private T data;
    @ApiModelProperty(value="\u9519\u8bef\u4fe1\u606f")
    private Map<String, Object> errors;
    @ApiModelProperty(value="\u65f6\u95f4\u6233")
    private long timestamp = DateTimeUtil.timeMills();
    @ApiModelProperty(value="\u5206\u9875\u6570\u636e\u603b\u6570")
    private long total;

    R() {
    }

    public static <T> R<T> ok() {
        return R.builder();
    }

    public static <T> R<T> ok(T data) {
        return R.ok().data(data);
    }

    public static <T> R<T> ok(T data, Long total) {
        R<T> ok = R.ok();
        R<T> data1 = ok.data(data);
        data1.setTotal(total);
        return data1;
    }

    public static R error() {
        return R.error((ErrorCode)BasisCode.SERVER_ERROR, "\u64cd\u4f5c\u5931\u8d25");
    }

    public static R error(String msg) {
        return R.error((ErrorCode)BasisCode.SERVER_ERROR, msg);
    }

    public static R error(ErrorCode code, String msg) {
        return R.builder().code(code).message(msg);
    }

    public static <T> R error(ErrorCode code, String msg, T data) {
        return R.builder().code(code).message(msg).data(data);
    }

    public static R error(ErrorCode errorCode, String msg, Map<String, Object> errors) {
        return R.builder().code(errorCode).message(msg).error(errors);
    }

    public static R state(boolean state) {
        return state ? R.ok().data(true) : R.error().data(false);
    }

    public static R empty() {
        return R.ok(Collections.emptyMap());
    }

    public static R emptyList() {
        return R.ok(Collections.emptyList());
    }

    public R error(Map<String, Object> errors) {
        this.errors = errors;
        return this;
    }

    public R message(String message) {
        this.msg = message;
        return this;
    }

    public R code(ErrorCode errorCode) {
        this.code = errorCode.getCode();
        return this;
    }

    public R<T> data(T data) {
        this.data = data;
        return this;
    }

    private static <T> R builder() {
        return new R<T>();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public Map<String, Object> getErrors() {
        return this.errors;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTotal() {
        return this.total;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setErrors(Map<String, Object> errors) {
        this.errors = errors;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof R)) {
            return false;
        }
        R other = (R)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Map<String, Object> this$errors = this.getErrors();
        Map<String, Object> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof R;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Map<String, Object> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", errors=" + this.getErrors() + ", timestamp=" + this.getTimestamp() + ", total=" + this.getTotal() + ")";
    }
}

