/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.server.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.base.Strings;
import com.jingtong.util.datetime.DateTimeUtil;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;

public class CustomeLocalDateTimeDeserializer
extends JsonDeserializer<LocalDateTime> {
    public LocalDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        String timestamp = parser.getText();
        if (Strings.isNullOrEmpty((String)timestamp) || Long.parseLong(timestamp) <= 0L) {
            return null;
        }
        return Instant.ofEpochMilli(Long.parseLong(timestamp)).atZone(DateTimeUtil.DEFAULT_ZONE).toLocalDateTime();
    }
}

