/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.server.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.jingtong.util.serialize.LocalDateSerialize;
import com.jingtong.util.serialize.UnixDateDeserializer;
import com.jingtong.util.serialize.UnixDateTimeMillsSerialize;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Configuration
public class FeignConfig
implements RequestInterceptor {
    public void apply(RequestTemplate requestTemplate) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return;
        }
        HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration values = request.getHeaders(name);
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    requestTemplate.header(name, new String[]{value});
                }
            }
        }
    }

    @Bean
    public Decoder feignDecoder() {
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter(this.customObjectMapper());
        ObjectFactory objectFactory = () -> FeignConfig.lambda$feignDecoder$0((HttpMessageConverter)jacksonConverter);
        return new ResponseEntityDecoder((Decoder)new SpringDecoder(objectFactory));
    }

    @Bean
    public Encoder feignEncoder() {
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter(this.customObjectMapper());
        ObjectFactory objectFactory = () -> FeignConfig.lambda$feignEncoder$1((HttpMessageConverter)jacksonConverter);
        return new SpringEncoder(objectFactory);
    }

    public ObjectMapper customObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        objectMapper.registerModule((Module)simpleModule);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new UnixDateTimeMillsSerialize());
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerialize());
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new UnixDateDeserializer());
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        objectMapper.registerModule((Module)javaTimeModule);
        return objectMapper;
    }

    private static /* synthetic */ HttpMessageConverters lambda$feignEncoder$1(HttpMessageConverter jacksonConverter) throws BeansException {
        return new HttpMessageConverters(new HttpMessageConverter[]{jacksonConverter});
    }

    private static /* synthetic */ HttpMessageConverters lambda$feignDecoder$0(HttpMessageConverter jacksonConverter) throws BeansException {
        return new HttpMessageConverters(new HttpMessageConverter[]{jacksonConverter});
    }
}

