/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.server.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.jingtong.server.config.TenantProperties;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@MapperScan(value={"com.jixiang.**.infra.dao", "com.jixiang.**.dao"})
public class MybatisPlusConfig {
    private final TenantProperties tenantProperties;
    private final TenantLineInnerInterceptor tenantLineInnerInterceptor;

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        boolean enableTenant = this.tenantProperties.getEnable();
        if (enableTenant) {
            interceptor.addInnerInterceptor((InnerInterceptor)this.tenantLineInnerInterceptor);
        }
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor(DbType.MYSQL);
        paginationInnerInterceptor.setMaxLimit(Long.valueOf(500L));
        interceptor.addInnerInterceptor((InnerInterceptor)paginationInnerInterceptor);
        return interceptor;
    }

    @Bean
    public MybatisPlusInterceptor optimisticLockerInnerInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        return interceptor;
    }

    public MybatisPlusConfig(TenantProperties tenantProperties, TenantLineInnerInterceptor tenantLineInnerInterceptor) {
        this.tenantProperties = tenantProperties;
        this.tenantLineInnerInterceptor = tenantLineInnerInterceptor;
    }
}

