/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.server.config;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.jingtong.server.config.MybatisPlusConfig;
import com.jingtong.server.config.TenantProperties;
import com.jingtong.server.web.LoginUserHolder;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={MybatisPlusConfig.class})
@EnableConfigurationProperties(value={TenantProperties.class})
public class TenantConfig {
    private static final Logger log = LoggerFactory.getLogger(TenantConfig.class);
    private final TenantProperties tenantProperties;

    @Bean
    public TenantLineInnerInterceptor tenantLineInnerInterceptor() {
        return new TenantLineInnerInterceptor(new TenantLineHandler(){

            public Expression getTenantId() {
                String tenant = LoginUserHolder.getBloc();
                log.info("\u83b7\u53d6\u5230\u4e86\u5e73\u53f0\u7f16\u7801\uff1a{}", (Object)tenant);
                if (tenant != null) {
                    return new StringValue(tenant);
                }
                return new NullValue();
            }

            public String getTenantIdColumn() {
                return TenantConfig.this.tenantProperties.getColumn();
            }

            public boolean ignoreTable(String tableName) {
                return TenantConfig.this.tenantProperties.getIgnoreTables().stream().anyMatch(t -> t.equalsIgnoreCase(tableName));
            }
        });
    }

    public TenantConfig(TenantProperties tenantProperties) {
        this.tenantProperties = tenantProperties;
    }
}

