/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.server.config;

import com.google.common.base.Strings;
import com.jingtong.util.datetime.DateTimeUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;

@Configuration
public class TimestampToLocalDateTimeConverterConfig
implements Converter<String, LocalDateTime> {
    public LocalDateTime convert(String timestamp) {
        if (Strings.isNullOrEmpty((String)timestamp) || Long.parseLong(timestamp) <= 0L) {
            return null;
        }
        return Instant.ofEpochMilli(Long.parseLong(timestamp)).atZone(DateTimeUtil.DEFAULT_ZONE).toLocalDateTime();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimestampToLocalDateTimeConverterConfig)) {
            return false;
        }
        TimestampToLocalDateTimeConverterConfig other = (TimestampToLocalDateTimeConverterConfig)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof TimestampToLocalDateTimeConverterConfig;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "TimestampToLocalDateTimeConverterConfig()";
    }
}

