/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.server.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadUtil.class);
    private static final String FIREFOX_AGENT = "firefox";
    private static final String SAFARI_AGENT = "safari";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadExcel(HttpServletResponse response, String fileName, Workbook workbook) throws IOException {
        response.reset();
        response.setContentType("application/force-download");
        ServletOutputStream os = null;
        try {
            fileName = fileName + ".xlsx";
            String fileNameURL = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileNameURL + ";filename*=utf-8''" + fileNameURL);
            os = response.getOutputStream();
            workbook.write((OutputStream)os);
            os.flush();
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("file name encoding has error!" + e);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadExcel(HttpServletResponse response, HttpServletRequest request, String title, XSSFWorkbook workbook) throws IOException {
        response.reset();
        response.setContentType("application/force-download");
        String exportTitle = title + ".xlsx";
        ServletOutputStream os = null;
        try {
            String agent = request.getHeader("User-Agent");
            String enableFileName = DownloadUtil.parseAgentDownloadFIleName(exportTitle, agent);
            response.addHeader("Content-Disposition", "attachment;fileName=" + enableFileName);
            os = response.getOutputStream();
            workbook.write((OutputStream)os);
            os.flush();
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("file name encoding has error!" + e);
        }
        finally {
            IOUtils.closeQuietly(os);
        }
    }

    private static String parseAgentDownloadFIleName(String exportTitle, String agent) {
        String enableFileName;
        try {
            enableFileName = agent != null && StringUtils.containsIgnoreCase((CharSequence)agent, (CharSequence)FIREFOX_AGENT) ? "=?UTF-8?B?" + new String(Base64.encodeBase64((byte[])exportTitle.getBytes("UTF-8"))) + "?=" : (agent != null && StringUtils.containsIgnoreCase((CharSequence)agent, (CharSequence)SAFARI_AGENT) ? new String(exportTitle.getBytes("UTF-8"), "ISO-8859-1") : URLEncoder.encode(exportTitle, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u751f\u6210\u4e0b\u8f7d\u6587\u4ef6\u540d\u79f0\u5904\u7406\u89e3\u6790\u5931\u8d25\uff0c\u6587\u4ef6\u540d\u79f0\u4e3a {} ", (Object)exportTitle, (Object)e);
            enableFileName = exportTitle;
        }
        return enableFileName;
    }
}

