/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.server.util;

import cn.hutool.core.util.StrUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class HttpContextUtils {
    public static HttpServletRequest getHttpServletRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }

    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        Enumeration parameters = request.getParameterNames();
        HashMap<String, String> params = new HashMap<String, String>();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            String value = request.getParameter(parameter);
            if (!StrUtil.isNotBlank((CharSequence)value)) continue;
            params.put(parameter, value);
        }
        return params;
    }

    public static String getLanguage() {
        String defaultLanguage = "zh-CN";
        HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
        if (request == null) {
            return defaultLanguage;
        }
        defaultLanguage = request.getHeader("Accept-Language");
        return defaultLanguage;
    }
}

