/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.server.web;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jingtong.base.status.DatapermCondition;
import com.jingtong.server.model.SysPermissionDataRuleModel;
import com.jingtong.server.web.LoginUserHolder;
import com.jingtong.util.serialize.JsonMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class DataPermHandler {
    private static final Logger log = LoggerFactory.getLogger(DataPermHandler.class);

    private DataPermHandler() {
    }

    public static List<SysPermissionDataRuleModel> currentDataPerms() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String userJson = request.getHeader("dataperms");
        if (StrUtil.isEmpty((CharSequence)userJson)) {
            return Collections.emptyList();
        }
        return JsonMapper.listOfJson((String)userJson, SysPermissionDataRuleModel.class);
    }

    public static String initDatapermsSql() {
        List<SysPermissionDataRuleModel> sysPermissionDataRuleModels = DataPermHandler.currentDataPerms();
        String resultSql = "";
        for (SysPermissionDataRuleModel sysPermissionDataRuleModel : sysPermissionDataRuleModels) {
            Pair<String, Object[]> sqlAndVal = DataPermHandler.generateSql(sysPermissionDataRuleModel);
            String sql = (String)sqlAndVal.getKey();
            Object[] value = (Object[])sqlAndVal.getValue();
            if (Strings.isNullOrEmpty((String)sql)) continue;
            log.info("\u5904\u7406\u7684sql:{}", (Object)sql);
            if (Objects.isNull(value)) continue;
        }
        return resultSql;
    }

    public static <T> LambdaQueryWrapper<T> initDataPerms() {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        List<SysPermissionDataRuleModel> sysPermissionDataRuleModels = DataPermHandler.currentDataPerms();
        boolean first = true;
        for (SysPermissionDataRuleModel sysPermissionDataRuleModel : sysPermissionDataRuleModels) {
            Pair<String, Object[]> sqlAndVal = DataPermHandler.generateSql(sysPermissionDataRuleModel);
            String sql = (String)sqlAndVal.getKey();
            Object[] value = (Object[])sqlAndVal.getValue();
            if (!Strings.isNullOrEmpty((String)sql)) {
                if (!Objects.isNull(value)) {
                    if (!first) {
                        ((LambdaQueryWrapper)lambdaQueryWrapper.or()).apply(sql, value);
                    } else {
                        lambdaQueryWrapper.apply(sql, value);
                    }
                } else if (!first) {
                    ((LambdaQueryWrapper)lambdaQueryWrapper.or()).apply(sql, new Object[0]);
                } else {
                    lambdaQueryWrapper.apply(sql, new Object[0]);
                }
            }
            first = false;
        }
        return lambdaQueryWrapper;
    }

    public static Pair<String, Object[]> generateSql(SysPermissionDataRuleModel sysPermissionDataRuleModel) {
        Integer ruleConditions = sysPermissionDataRuleModel.getRuleConditions();
        DatapermCondition datapermCondition = DatapermCondition.forValue((Integer)ruleConditions);
        String ruleColumn = sysPermissionDataRuleModel.getRuleColumn();
        String ruleValue = sysPermissionDataRuleModel.getRuleValue();
        String sql = "";
        Object[] o = null;
        switch (datapermCondition) {
            case ALL: {
                break;
            }
            case SELF: {
                sql = ruleColumn + " = {0}";
                o = new Object[]{LoginUserHolder.getUserCode()};
                break;
            }
            case ALL_ORG: {
                return DataPermHandler.generateOrgSql(ruleColumn, LoginUserHolder.getUserOrgs());
            }
            case ALL_ORG_SUB: {
                return DataPermHandler.generateOrgSql(ruleColumn, LoginUserHolder.getSubOrgs());
            }
            case CUSTOM: {
                sql = ruleColumn + " " + ruleValue;
                break;
            }
        }
        return new Pair((Object)sql, o);
    }

    public static Pair<String, Object[]> generateOrgSql(String ruleColumn, Set<String> userOrgs) {
        Object[] o;
        String sql = "";
        if (CollectionUtil.isEmpty(userOrgs)) {
            sql = "1!=1";
            o = null;
        } else {
            ArrayList str = Lists.newArrayListWithCapacity((int)userOrgs.size());
            int i = 0;
            for (String userOrg : userOrgs) {
                str.add("{" + i + "}");
                ++i;
            }
            sql = ruleColumn + " IN (" + StrUtil.join((CharSequence)",", (Object[])new Object[]{str}) + ")";
            o = userOrgs.toArray();
        }
        return new Pair((Object)sql, o);
    }
}

