/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.server.web;

import cn.hutool.core.util.StrUtil;
import com.jingtong.data.auth.UserInfo;
import com.jingtong.util.serialize.JsonMapper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class LoginUserHolder {
    private LoginUserHolder() {
    }

    public static Optional<UserInfo> currentUser() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String userJson = request.getHeader("user");
        if (StrUtil.isEmpty((CharSequence)userJson)) {
            return Optional.empty();
        }
        return JsonMapper.fromJson((String)userJson, UserInfo.class);
    }

    public static String getUserCode() {
        Optional<UserInfo> userInfo = LoginUserHolder.currentUser();
        if (!userInfo.isPresent()) {
            return null;
        }
        return userInfo.get().getCode();
    }

    public static Set<String> getUserOrgs() {
        Optional<UserInfo> userInfo = LoginUserHolder.currentUser();
        if (!userInfo.isPresent()) {
            return null;
        }
        return userInfo.get().getOrgCodes();
    }

    public static Set<String> getSubOrgs() {
        Optional<UserInfo> userInfo = LoginUserHolder.currentUser();
        if (!userInfo.isPresent()) {
            return null;
        }
        return userInfo.get().getSubOrgCodes();
    }

    public static String getBloc() {
        Optional<UserInfo> userInfo = LoginUserHolder.currentUser();
        if (!userInfo.isPresent()) {
            return "sys";
        }
        return userInfo.get().getBloc() == null ? "sys" : userInfo.get().getBloc();
    }

    public static List<String> getRoles() {
        Optional<UserInfo> userInfo = LoginUserHolder.currentUser();
        if (!userInfo.isPresent()) {
            return null;
        }
        return userInfo.get().getRoles();
    }

    public static String getCurrentRole() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String currentRole = request.getHeader("currentrole");
        if (StrUtil.isEmpty((CharSequence)currentRole)) {
            return "";
        }
        return currentRole;
    }
}

