/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.logbook;

import com.jingtong.logbook.infra.config.LogbookProp;
import com.jingtong.logbook.logic.LogBookInterceptor;
import com.jingtong.logbook.logic.LogbookThrowsAdvice;

import org.springframework.aop.Advisor;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import lombok.RequiredArgsConstructor;

/**
 * <p> </p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
@Configuration
@RequiredArgsConstructor
public class LogbookConfiguration {
    private final LogbookProp logbookConfig;
    private final LogbookThrowsAdvice logbookThrowsAdvice;
    private final LogBookInterceptor logBookInterceptor;


    @Bean
    public Advisor operationThrowsAop() {
        AspectJExpressionPointcut adapterPointcut = new AspectJExpressionPointcut();
        adapterPointcut.setExpression(logbookConfig.getExecution());
        Advisor throwsAdviceAdvisor = new DefaultPointcutAdvisor(adapterPointcut, logbookThrowsAdvice);
        return throwsAdviceAdvisor;
    }

    @Bean
    public Advisor operationLogAop() {
        AspectJExpressionPointcut adapterPointcut = new AspectJExpressionPointcut();
        adapterPointcut.setExpression(logbookConfig.getExecution());
        Advisor throwsAdviceAdvisor = new DefaultPointcutAdvisor(adapterPointcut, logBookInterceptor);
        return throwsAdviceAdvisor;
    }
}
