/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.logbook.infra.dto;

import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;

import java.io.Serializable;

import cn.hutool.core.util.StrUtil;
import lombok.Data;

/**
 * <p> </p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
@Data
public class LogDTO implements Serializable {
    private String MICRO_MESSENGER = "MicroMessenger";
    private static final long serialVersionUID = -8840469474232918338L;
    private String ip;
    private String url;
    private String businessName;
    private String userId;
    private String userName;
    private Integer timeStamp;
    private String paramData;
    private String returnData;
    private String userAgent;
    private String deviceName;

    private String getDeviceName(String userAgentStr) {
        final UserAgent userAgent = UserAgent.parseUserAgentString(userAgentStr);
        final OperatingSystem operatingSystem = userAgent.getOperatingSystem();
        final String browserName;
        if (!userAgentStr.contains(MICRO_MESSENGER)) {
            final Browser browser = userAgent.getBrowser();
            browserName = browser.getName();
        } else {
            browserName = "WeiXin";
        }
        return StrUtil.format("{}-{}", operatingSystem.getName(), browserName);
    }

    public static LogDTO buildByRequest(String ipAddress, String userAgent) {
        LogDTO logDTO = new LogDTO();
        logDTO.setIp(ipAddress);
        logDTO.setUserAgent(userAgent);
        return logDTO;
    }

    public LogDTO() {

    }

    public LogDTO(String ip,
                  String url,
                  String businessName,
                  String userId,
                  String userName,
                  Integer timeStamp,
                  String paramData,
                  String returnData,
                  String userAgent) {
        this.ip = ip;
        this.url = url;
        this.businessName = businessName;
        this.userId = userId;
        this.userName = userName;
        this.timeStamp = timeStamp;
        this.paramData = paramData;
        this.returnData = returnData;
        this.userAgent = userAgent;
        this.deviceName = getDeviceName(userAgent);
    }

}
