/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.logbook.logic;

import com.google.common.collect.Maps;

import com.jingtong.logbook.infra.dto.LogDTO;
import com.jingtong.logbook.infra.dto.LogSettingDTO;
import com.jingtong.logbook.logic.util.ClassUtil;

import org.springframework.stereotype.Service;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.TimerTask;

import cn.hutool.core.util.ArrayUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * <p>日志解析逻辑控制</p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
@Slf4j
@Service
public class LogAnalysisLogic {
    private final LogSettingLogic logSettingLogic;
    private final LoginUserLogic loginUserLogic;
    private final LogStorageLogic logStorageLogic;

    public LogAnalysisLogic(LogSettingLogic logSettingLogic,
                            LoginUserLogic loginUserLogic,
                            LogStorageLogic logStorageLogic) {
        this.logSettingLogic = logSettingLogic;
        this.loginUserLogic = loginUserLogic;
        this.logStorageLogic = logStorageLogic;
    }

    public void analysisThrowException(Class<?> target,
                                       Method method,
                                       Object[] pointArgs,
                                       Throwable subclass,
                                       String url,
                                       final LogDTO logDTO) {
        handler(target, method, pointArgs, url, logDTO, subclass);
    }

    public void handler(Class<?> target,
                        Method method, Object[] pointArgs,
                        String url,
                        LogDTO logDTO, Throwable subclass) {
        handler(target, method, pointArgs, null, url, logDTO, subclass);
    }

    public void analysis(Class<?> target,
                         Method method,
                         Object[] pointArgs,
                         Object proceed,
                         String url,
                         final LogDTO logDTO) {
        handler(target, method, pointArgs, proceed, url, logDTO);
    }

    public void handler(Class<?> target,
                        Method method, Object[] pointArgs,
                        Object proceed,
                        String url,
                        LogDTO logDTO) {
        handler(target, method, pointArgs, proceed, url, logDTO, null);
    }

    private void handler(Class<?> targetClass,
                         Method method, Object[] pointArgs,
                         Object proceed,
                         String url,
                         LogDTO logDTO, Throwable subclass) {
        String methodName = method.getName();
        //获取拦截方法的参数
        String className = targetClass.getName();
        String userId = loginUserLogic.getUserId();
        String userName = loginUserLogic.getUserName();
        TimerTask businessTask = new TimerTask() {
            @Override
            public void run() {
                final String[] fieldsNames;
                String message = "";
                final LogSettingDTO logSettingDTO = logSettingLogic.getByUrl(url);
                if (Objects.isNull(logSettingDTO)) {
                    log.error("日志配置KEY没有配置，无法记录日志, 类 {}, 方法 {}, 请求地址 {}", className, methodName, url);
                    return;
                }
                String contentFormat = logSettingDTO.getParamTemplate();
                String resultFormat = logSettingDTO.getReturnTemplate();
                final String businessName = logSettingDTO.getBusinessName();
                try {
                    fieldsNames = ClassUtil.getFieldsName(targetClass, methodName);
                    if (ArrayUtil.isNotEmpty(pointArgs)) {
                        Map<String, Object> argsMap = Maps.newHashMap();
                        for (int i = 0; i < pointArgs.length; i++) {
                            Object pointArg = pointArgs[i];
                            argsMap.put(fieldsNames[i], pointArg);
                        }
                        message = FreeMarkers.renderString(contentFormat, argsMap);
                    }
                    String result = "";
                    if (!Objects.isNull(proceed)) {
                        Map<String, Object> argsMap = Maps.newHashMap();
                        argsMap.put("result", proceed);
                        result = FreeMarkers.renderString(resultFormat, argsMap);
                    } else {
                        result = subclass.getMessage();
                    }
                    LogDTO logDTO1 = new LogDTO(logDTO.getIp(),url, businessName, userId, userName, 0, message, result, logDTO.getUserAgent());
                    logStorageLogic.save(logDTO1);
                } catch (Exception e) {
                    e.printStackTrace();
                    log.error("获取参数方法名称出错!");
                }
            }
        };
        LogManager.me().executeLog(businessTask);
    }
}
