/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.logbook.logic;

import com.google.common.net.HttpHeaders;

import com.jingtong.logbook.infra.dto.LogDTO;
import com.jingtong.logbook.infra.until.RequestUtil;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.lang.reflect.Method;

import javax.servlet.http.HttpServletRequest;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * <p>正常方法日志增强</p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class LogBookInterceptor implements MethodInterceptor {
    private final LogAnalysisLogic logAnalysisLogic;

    @Override
    public Object invoke(MethodInvocation point) throws Throwable {
        Object proceed = point.proceed();
        Object target = point.getThis();
        final Class<?> targetClass = target.getClass();
        Method method = point.getMethod();
        final Object[] pointArgs = point.getArguments();
        // 取得请求参数
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String url = request.getRequestURI();
        final String userAgent = request.getHeader(HttpHeaders.USER_AGENT);
        String ipAddress = RequestUtil.getIpAddress(request);
        final LogDTO logDTO = LogDTO.buildByRequest(ipAddress, userAgent);
        logAnalysisLogic.analysis(targetClass, method, pointArgs, proceed, url, logDTO);
        return proceed;
    }
}
