package com.jingtong.logbook.logic;

import com.google.common.util.concurrent.ThreadFactoryBuilder;

import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/**
 * <p> 日志管理器</p>
 *
 * @author Dark.Yang
 * @version 1.0
 * @since JDK 1.7
 */
public class LogManager {

    /**
     * 日志记录操作延时
     */
    private static final int OPERATE_DELAY_TIME = 10;
    private static LogManager logManager = new LogManager();
    /**
     * 异步操作记录日志的线程池
     */
    private final ScheduledThreadPoolExecutor executor;

    private LogManager() {

        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder()
                .setNameFormat("toa-log-pool-%d").build();

        executor = new ScheduledThreadPoolExecutor(10, namedThreadFactory);
    }

    public static LogManager me() {
        return logManager;
    }

    public void executeLog(TimerTask task) {
        executor.schedule(task, OPERATE_DELAY_TIME, TimeUnit.MILLISECONDS);
    }
}
