/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2021
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jingtong.logbook.logic;

import com.google.common.net.HttpHeaders;

import com.jingtong.logbook.infra.dto.LogDTO;
import com.jingtong.logbook.infra.until.RequestUtil;

import org.springframework.aop.ThrowsAdvice;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.lang.reflect.Method;

import javax.servlet.http.HttpServletRequest;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * <p>方法报错，日志记录增强</p>
 *
 * @author BOGON
 * @version 1.0
 * @since JDK 1.8
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class LogbookThrowsAdvice implements ThrowsAdvice {
    private final LogAnalysisLogic logAnalysisLogic;



    public void afterThrowing(Method method, Object[] pointArgs, Object target, Throwable subclass) throws Throwable {
        // 取得请求参数
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        final Class<?> targetClass = target.getClass();
        String url = request.getRequestURI();
        final String userAgent = request.getHeader(HttpHeaders.USER_AGENT);
        String ipAddress = RequestUtil.getIpAddress(request);
        final LogDTO logDTO = LogDTO.buildByRequest(ipAddress, userAgent);
        logAnalysisLogic.analysisThrowException(targetClass, method, pointArgs, subclass, url, logDTO);
    }
}
