/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.logbook;

import com.jingtong.logbook.infra.config.LogbookProp;
import com.jingtong.logbook.logic.LogBookInterceptor;
import com.jingtong.logbook.logic.LogbookThrowsAdvice;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LogbookConfiguration {
    private final LogbookProp logbookConfig;
    private final LogbookThrowsAdvice logbookThrowsAdvice;
    private final LogBookInterceptor logBookInterceptor;

    @Bean
    public Advisor operationThrowsAop() {
        AspectJExpressionPointcut adapterPointcut = new AspectJExpressionPointcut();
        adapterPointcut.setExpression(this.logbookConfig.getExecution());
        DefaultPointcutAdvisor throwsAdviceAdvisor = new DefaultPointcutAdvisor((Pointcut)adapterPointcut, (Advice)this.logbookThrowsAdvice);
        return throwsAdviceAdvisor;
    }

    @Bean
    public Advisor operationLogAop() {
        AspectJExpressionPointcut adapterPointcut = new AspectJExpressionPointcut();
        adapterPointcut.setExpression(this.logbookConfig.getExecution());
        DefaultPointcutAdvisor throwsAdviceAdvisor = new DefaultPointcutAdvisor((Pointcut)adapterPointcut, (Advice)this.logBookInterceptor);
        return throwsAdviceAdvisor;
    }

    public LogbookConfiguration(LogbookProp logbookConfig, LogbookThrowsAdvice logbookThrowsAdvice, LogBookInterceptor logBookInterceptor) {
        this.logbookConfig = logbookConfig;
        this.logbookThrowsAdvice = logbookThrowsAdvice;
        this.logBookInterceptor = logBookInterceptor;
    }
}

