/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.logbook.infra.dto;

import cn.hutool.core.util.StrUtil;
import eu.bitwalker.useragentutils.Browser;
import eu.bitwalker.useragentutils.OperatingSystem;
import eu.bitwalker.useragentutils.UserAgent;
import java.io.Serializable;

public class LogDTO
implements Serializable {
    private String MICRO_MESSENGER = "MicroMessenger";
    private static final long serialVersionUID = -8840469474232918338L;
    private String ip;
    private String url;
    private String businessName;
    private String userId;
    private String userName;
    private Integer timeStamp;
    private String paramData;
    private String returnData;
    private String userAgent;
    private String deviceName;

    private String getDeviceName(String userAgentStr) {
        String browserName;
        UserAgent userAgent = UserAgent.parseUserAgentString((String)userAgentStr);
        OperatingSystem operatingSystem = userAgent.getOperatingSystem();
        if (!userAgentStr.contains(this.MICRO_MESSENGER)) {
            Browser browser = userAgent.getBrowser();
            browserName = browser.getName();
        } else {
            browserName = "WeiXin";
        }
        return StrUtil.format((CharSequence)"{}-{}", (Object[])new Object[]{operatingSystem.getName(), browserName});
    }

    public static LogDTO buildByRequest(String ipAddress, String userAgent) {
        LogDTO logDTO = new LogDTO();
        logDTO.setIp(ipAddress);
        logDTO.setUserAgent(userAgent);
        return logDTO;
    }

    public LogDTO() {
    }

    public LogDTO(String ip, String url, String businessName, String userId, String userName, Integer timeStamp, String paramData, String returnData, String userAgent) {
        this.ip = ip;
        this.url = url;
        this.businessName = businessName;
        this.userId = userId;
        this.userName = userName;
        this.timeStamp = timeStamp;
        this.paramData = paramData;
        this.returnData = returnData;
        this.userAgent = userAgent;
        this.deviceName = this.getDeviceName(userAgent);
    }

    public String getMICRO_MESSENGER() {
        return this.MICRO_MESSENGER;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUrl() {
        return this.url;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public Integer getTimeStamp() {
        return this.timeStamp;
    }

    public String getParamData() {
        return this.paramData;
    }

    public String getReturnData() {
        return this.returnData;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setMICRO_MESSENGER(String MICRO_MESSENGER) {
        this.MICRO_MESSENGER = MICRO_MESSENGER;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBusinessName(String businessName) {
        this.businessName = businessName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setTimeStamp(Integer timeStamp) {
        this.timeStamp = timeStamp;
    }

    public void setParamData(String paramData) {
        this.paramData = paramData;
    }

    public void setReturnData(String returnData) {
        this.returnData = returnData;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogDTO)) {
            return false;
        }
        LogDTO other = (LogDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$timeStamp = this.getTimeStamp();
        Integer other$timeStamp = other.getTimeStamp();
        if (this$timeStamp == null ? other$timeStamp != null : !((Object)this$timeStamp).equals(other$timeStamp)) {
            return false;
        }
        String this$MICRO_MESSENGER = this.getMICRO_MESSENGER();
        String other$MICRO_MESSENGER = other.getMICRO_MESSENGER();
        if (this$MICRO_MESSENGER == null ? other$MICRO_MESSENGER != null : !this$MICRO_MESSENGER.equals(other$MICRO_MESSENGER)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$businessName = this.getBusinessName();
        String other$businessName = other.getBusinessName();
        if (this$businessName == null ? other$businessName != null : !this$businessName.equals(other$businessName)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$paramData = this.getParamData();
        String other$paramData = other.getParamData();
        if (this$paramData == null ? other$paramData != null : !this$paramData.equals(other$paramData)) {
            return false;
        }
        String this$returnData = this.getReturnData();
        String other$returnData = other.getReturnData();
        if (this$returnData == null ? other$returnData != null : !this$returnData.equals(other$returnData)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        String this$deviceName = this.getDeviceName();
        String other$deviceName = other.getDeviceName();
        return !(this$deviceName == null ? other$deviceName != null : !this$deviceName.equals(other$deviceName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $timeStamp = this.getTimeStamp();
        result = result * 59 + ($timeStamp == null ? 43 : ((Object)$timeStamp).hashCode());
        String $MICRO_MESSENGER = this.getMICRO_MESSENGER();
        result = result * 59 + ($MICRO_MESSENGER == null ? 43 : $MICRO_MESSENGER.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $businessName = this.getBusinessName();
        result = result * 59 + ($businessName == null ? 43 : $businessName.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $paramData = this.getParamData();
        result = result * 59 + ($paramData == null ? 43 : $paramData.hashCode());
        String $returnData = this.getReturnData();
        result = result * 59 + ($returnData == null ? 43 : $returnData.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        String $deviceName = this.getDeviceName();
        result = result * 59 + ($deviceName == null ? 43 : $deviceName.hashCode());
        return result;
    }

    public String toString() {
        return "LogDTO(MICRO_MESSENGER=" + this.getMICRO_MESSENGER() + ", ip=" + this.getIp() + ", url=" + this.getUrl() + ", businessName=" + this.getBusinessName() + ", userId=" + this.getUserId() + ", userName=" + this.getUserName() + ", timeStamp=" + this.getTimeStamp() + ", paramData=" + this.getParamData() + ", returnData=" + this.getReturnData() + ", userAgent=" + this.getUserAgent() + ", deviceName=" + this.getDeviceName() + ")";
    }
}

