/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.logbook.logic;

import cn.hutool.core.util.ArrayUtil;
import com.google.common.collect.Maps;
import com.jingtong.logbook.infra.dto.LogDTO;
import com.jingtong.logbook.infra.dto.LogSettingDTO;
import com.jingtong.logbook.logic.FreeMarkers;
import com.jingtong.logbook.logic.LogManager;
import com.jingtong.logbook.logic.LogSettingLogic;
import com.jingtong.logbook.logic.LogStorageLogic;
import com.jingtong.logbook.logic.LoginUserLogic;
import com.jingtong.logbook.logic.util.ClassUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Objects;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogAnalysisLogic {
    private static final Logger log = LoggerFactory.getLogger(LogAnalysisLogic.class);
    private final LogSettingLogic logSettingLogic;
    private final LoginUserLogic loginUserLogic;
    private final LogStorageLogic logStorageLogic;

    public LogAnalysisLogic(LogSettingLogic logSettingLogic, LoginUserLogic loginUserLogic, LogStorageLogic logStorageLogic) {
        this.logSettingLogic = logSettingLogic;
        this.loginUserLogic = loginUserLogic;
        this.logStorageLogic = logStorageLogic;
    }

    public void analysisThrowException(Class<?> target, Method method, Object[] pointArgs, Throwable subclass, String url, LogDTO logDTO) {
        this.handler(target, method, pointArgs, url, logDTO, subclass);
    }

    public void handler(Class<?> target, Method method, Object[] pointArgs, String url, LogDTO logDTO, Throwable subclass) {
        this.handler(target, method, pointArgs, null, url, logDTO, subclass);
    }

    public void analysis(Class<?> target, Method method, Object[] pointArgs, Object proceed, String url, LogDTO logDTO) {
        this.handler(target, method, pointArgs, proceed, url, logDTO);
    }

    public void handler(Class<?> target, Method method, Object[] pointArgs, Object proceed, String url, LogDTO logDTO) {
        this.handler(target, method, pointArgs, proceed, url, logDTO, null);
    }

    private void handler(final Class<?> targetClass, Method method, final Object[] pointArgs, final Object proceed, final String url, final LogDTO logDTO, final Throwable subclass) {
        final String methodName = method.getName();
        final String className = targetClass.getName();
        final String userId = this.loginUserLogic.getUserId();
        final String userName = this.loginUserLogic.getUserName();
        TimerTask businessTask = new TimerTask(){

            @Override
            public void run() {
                String message = "";
                LogSettingDTO logSettingDTO = LogAnalysisLogic.this.logSettingLogic.getByUrl(url);
                if (Objects.isNull(logSettingDTO)) {
                    log.error("\u65e5\u5fd7\u914d\u7f6eKEY\u6ca1\u6709\u914d\u7f6e\uff0c\u65e0\u6cd5\u8bb0\u5f55\u65e5\u5fd7, \u7c7b {}, \u65b9\u6cd5 {}, \u8bf7\u6c42\u5730\u5740 {}", new Object[]{className, methodName, url});
                    return;
                }
                String contentFormat = logSettingDTO.getParamTemplate();
                String resultFormat = logSettingDTO.getReturnTemplate();
                String businessName = logSettingDTO.getBusinessName();
                try {
                    String[] fieldsNames = ClassUtil.getFieldsName(targetClass, methodName);
                    if (ArrayUtil.isNotEmpty((Object[])pointArgs)) {
                        HashMap argsMap = Maps.newHashMap();
                        for (int i = 0; i < pointArgs.length; ++i) {
                            Object pointArg = pointArgs[i];
                            argsMap.put(fieldsNames[i], pointArg);
                        }
                        message = FreeMarkers.renderString(contentFormat, argsMap);
                    }
                    String result = "";
                    if (!Objects.isNull(proceed)) {
                        HashMap argsMap = Maps.newHashMap();
                        argsMap.put("result", proceed);
                        result = FreeMarkers.renderString(resultFormat, argsMap);
                    } else {
                        result = subclass.getMessage();
                    }
                    LogDTO logDTO1 = new LogDTO(logDTO.getIp(), url, businessName, userId, userName, 0, message, result, logDTO.getUserAgent());
                    LogAnalysisLogic.this.logStorageLogic.save(logDTO1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u83b7\u53d6\u53c2\u6570\u65b9\u6cd5\u540d\u79f0\u51fa\u9519!");
                }
            }
        };
        LogManager.me().executeLog(businessTask);
    }
}

