/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.logbook.logic;

import com.jingtong.logbook.infra.dto.LogDTO;
import com.jingtong.logbook.infra.until.RequestUtil;
import com.jingtong.logbook.logic.LogAnalysisLogic;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class LogBookInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LogBookInterceptor.class);
    private final LogAnalysisLogic logAnalysisLogic;

    public Object invoke(MethodInvocation point) throws Throwable {
        Object proceed = point.proceed();
        Object target = point.getThis();
        Class<?> targetClass = target.getClass();
        Method method = point.getMethod();
        Object[] pointArgs = point.getArguments();
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        String url = request.getRequestURI();
        String userAgent = request.getHeader("User-Agent");
        String ipAddress = RequestUtil.getIpAddress(request);
        LogDTO logDTO = LogDTO.buildByRequest(ipAddress, userAgent);
        this.logAnalysisLogic.analysis(targetClass, method, pointArgs, proceed, url, logDTO);
        return proceed;
    }

    public LogBookInterceptor(LogAnalysisLogic logAnalysisLogic) {
        this.logAnalysisLogic = logAnalysisLogic;
    }
}

