/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.logbook.logic;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class LogManager {
    private static final int OPERATE_DELAY_TIME = 10;
    private static LogManager logManager = new LogManager();
    private final ScheduledThreadPoolExecutor executor;

    private LogManager() {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("toa-log-pool-%d").build();
        this.executor = new ScheduledThreadPoolExecutor(10, namedThreadFactory);
    }

    public static LogManager me() {
        return logManager;
    }

    public void executeLog(TimerTask task) {
        this.executor.schedule(task, 10L, TimeUnit.MILLISECONDS);
    }
}

