/*
 * Decompiled with CFR 0.152.
 */
package com.jingtong.logbook.logic;

import com.jingtong.logbook.infra.dto.LogDTO;
import com.jingtong.logbook.infra.until.RequestUtil;
import com.jingtong.logbook.logic.LogAnalysisLogic;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class LogbookThrowsAdvice
implements ThrowsAdvice {
    private static final Logger log = LoggerFactory.getLogger(LogbookThrowsAdvice.class);
    private final LogAnalysisLogic logAnalysisLogic;

    public void afterThrowing(Method method, Object[] pointArgs, Object target, Throwable subclass) throws Throwable {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        Class<?> targetClass = target.getClass();
        String url = request.getRequestURI();
        String userAgent = request.getHeader("User-Agent");
        String ipAddress = RequestUtil.getIpAddress(request);
        LogDTO logDTO = LogDTO.buildByRequest(ipAddress, userAgent);
        this.logAnalysisLogic.analysisThrowException(targetClass, method, pointArgs, subclass, url, logDTO);
    }

    public LogbookThrowsAdvice(LogAnalysisLogic logAnalysisLogic) {
        this.logAnalysisLogic = logAnalysisLogic;
    }
}

