/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.datatables;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.plugins.pagination.Pagination;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.jtech.marble.datatables.DataTablesPagination;
import com.jtech.marble.datatables.domain.Column;
import com.jtech.marble.datatables.domain.DataTablesInput;
import com.jtech.marble.datatables.domain.DataTablesOutput;
import com.jtech.marble.datatables.domain.Order;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;

public class DataTablesUtils {
    public static <Q> DataTablesPagination getPageable(DataTablesInput<Q> input) {
        if (input.getLength() == -1) {
            input.setStart(0);
            input.setLength(Integer.MAX_VALUE);
        }
        int start = (Integer)MoreObjects.firstNonNull((Object)input.getStart(), (Object)0);
        int current = start / input.getLength();
        Pagination pagination = new Pagination(current + 1, input.getLength().intValue());
        ArrayList orders = Lists.newArrayList();
        for (Order order : input.getOrder()) {
            Column column = input.getColumns().get(order.getColumn());
            pagination.setOpenSort(true);
            if (!column.getOrderable().booleanValue()) continue;
            String sortColumn = column.getData();
            if (!pagination.isOpenSort()) {
                pagination.setOrderByField(sortColumn);
                pagination.setOpenSort(true);
                String dir = order.getDir();
                if (StringUtils.equalsIgnoreCase((CharSequence)dir, (CharSequence)"asc")) {
                    pagination.setAsc(true);
                }
            }
            Sort.Direction sortDirection = Sort.Direction.fromString((String)order.getDir());
            orders.add(new Sort.Order(sortDirection, sortColumn));
        }
        DataTablesPagination dataTablesPagination = new DataTablesPagination();
        dataTablesPagination.setPagination(pagination);
        dataTablesPagination.setOrders(orders);
        return dataTablesPagination;
    }

    public static <E> DataTablesOutput<E> buildOut(DataTablesInput input, Page<E> page) {
        DataTablesOutput dataTablesOutput = new DataTablesOutput();
        dataTablesOutput.setData(page.getRecords());
        dataTablesOutput.setDraw(input.getDraw());
        dataTablesOutput.setRecordsTotal(page.getTotal());
        dataTablesOutput.setRecordsFiltered(page.getTotal());
        return dataTablesOutput;
    }

    public static <E> DataTablesOutput<E> buildOut(DataTablesInput input, Page<E> page, int total) {
        DataTablesOutput dataTablesOutput = new DataTablesOutput();
        dataTablesOutput.setData(page.getRecords());
        dataTablesOutput.setDraw(input.getDraw());
        dataTablesOutput.setRecordsTotal(total);
        dataTablesOutput.setRecordsFiltered(page.getTotal());
        return dataTablesOutput;
    }
}

