/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.shiro;

import com.jtech.marble.shiro.ShiroUser;
import java.util.Random;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

public class ShiroUtil {
    private static final String NAMES_DELIMETER = ",";
    private static final String HASHALGORITHMNAME = "SHA-1";
    private static final int HASHITERATIONS = 1024;

    public static String password(String credentials, String saltSource) {
        Md5Hash salt = new Md5Hash((Object)saltSource);
        return new SimpleHash(HASHALGORITHMNAME, (Object)credentials, (Object)salt, 1024).toString();
    }

    public static String getRandomSalt(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroUser getUser() {
        if (ShiroUtil.isGuest()) {
            return null;
        }
        return (ShiroUser)ShiroUtil.getSubject().getPrincipals().getPrimaryPrincipal();
    }

    public static Session getSession() {
        return ShiroUtil.getSubject().getSession();
    }

    public static <T> T getSessionAttr(String key) {
        Session session = ShiroUtil.getSession();
        return (T)(session != null ? session.getAttribute((Object)key) : null);
    }

    public static void setSessionAttr(String key, Object value) {
        Session session = ShiroUtil.getSession();
        session.setAttribute((Object)key, value);
    }

    public static void removeSessionAttr(String key) {
        Session session = ShiroUtil.getSession();
        if (session != null) {
            session.removeAttribute((Object)key);
        }
    }

    public static boolean hasRole(String roleName) {
        return ShiroUtil.getSubject() != null && roleName != null && roleName.length() > 0 && ShiroUtil.getSubject().hasRole(roleName);
    }

    public static boolean lacksRole(String roleName) {
        return !ShiroUtil.hasRole(roleName);
    }

    public static boolean hasAnyRoles(String roleNames) {
        boolean hasAnyRole = false;
        Subject subject = ShiroUtil.getSubject();
        if (subject != null && roleNames != null && roleNames.length() > 0) {
            for (String role : roleNames.split(NAMES_DELIMETER)) {
                if (!subject.hasRole(role.trim())) continue;
                hasAnyRole = true;
                break;
            }
        }
        return hasAnyRole;
    }

    public static boolean hasAllRoles(String roleNames) {
        boolean hasAllRole = true;
        Subject subject = ShiroUtil.getSubject();
        if (subject != null && roleNames != null && roleNames.length() > 0) {
            for (String role : roleNames.split(NAMES_DELIMETER)) {
                if (subject.hasRole(role.trim())) continue;
                hasAllRole = false;
                break;
            }
        }
        return hasAllRole;
    }

    public static boolean hasPermission(String permission) {
        return ShiroUtil.getSubject() != null && permission != null && permission.length() > 0 && ShiroUtil.getSubject().isPermitted(permission);
    }

    public static boolean lacksPermission(String permission) {
        return !ShiroUtil.hasPermission(permission);
    }

    public static boolean isAuthenticated() {
        return ShiroUtil.getSubject() != null && ShiroUtil.getSubject().isAuthenticated();
    }

    public static boolean notAuthenticated() {
        return !ShiroUtil.isAuthenticated();
    }

    public static boolean isUser() {
        return ShiroUtil.getSubject() != null && ShiroUtil.getSubject().getPrincipal() != null;
    }

    public static boolean isGuest() {
        return !ShiroUtil.isUser();
    }

    public static String principal() {
        if (ShiroUtil.getSubject() != null) {
            Object principal = ShiroUtil.getSubject().getPrincipal();
            return principal.toString();
        }
        return "";
    }
}

