/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.error;

import com.jtech.marble.error.ErrorCode;

public class ErrorModel {
    private final int code;
    private final String message;

    private ErrorModel(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static class Builder {
        private ErrorCode errorCode;
        private String message = "";

        Builder() {
        }

        public Builder setCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public ErrorModel createErrorModel() {
            return new ErrorModel(this.errorCode.getCode(), this.message);
        }
    }
}

