/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util;

import java.util.Date;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtil {
    public static final String YYYYMMDD_DASH_PATTERN = "yyyy-MM-dd";
    public static final String YEAR_PATTERN = "yyyy";
    public static final String YYYYMMDD_PATTERN = "yyyyMMdd";
    public static final String YYYYMMDD_TIME_PATTERN = "yyyyMMdd HH:mm:ss";
    public static final String YYYYMMDD_TIMES_PATTERN = "yyyyMMdd HH:mm:ss.SSS";
    public static final Locale DEFAULT_LOCALE = Locale.SIMPLIFIED_CHINESE;
    public static final DateTimeZone DEFAULT_TIMEZONE = DateTimeZone.forOffsetHours((int)8);

    public static DateTimeFormatter getDateTimeFormatter(String pattern) {
        return DateTimeFormat.forPattern((String)pattern).withZone(DEFAULT_TIMEZONE).withLocale(DEFAULT_LOCALE);
    }

    public static String year(Date date) {
        return DateUtil.getDateTimeFormatter(YEAR_PATTERN).print((ReadableInstant)new DateTime((Object)date));
    }

    public static String yyyyMMdd(Date date) {
        return DateUtil.getDateTimeFormatter(YYYYMMDD_PATTERN).print((ReadableInstant)new DateTime((Object)date));
    }

    public static String yyyyMMddDash(Date date) {
        return DateUtil.getDateTimeFormatter(YYYYMMDD_DASH_PATTERN).print((ReadableInstant)new DateTime((Object)date));
    }

    public static String yyyyMMddTime(Date date) {
        return DateUtil.getDateTimeFormatter(YYYYMMDD_TIME_PATTERN).print((ReadableInstant)new DateTime((Object)date));
    }

    public static String yyyyMMddTimes(Date date) {
        return DateUtil.getDateTimeFormatter(YYYYMMDD_TIMES_PATTERN).print((ReadableInstant)new DateTime((Object)date));
    }

    public static DateTime year(String dateFormat) {
        return DateUtil.getDateTimeFormatter(YEAR_PATTERN).parseDateTime(dateFormat);
    }

    public static DateTime yyyyMMdd(String dateFormat) {
        return DateUtil.getDateTimeFormatter(YYYYMMDD_PATTERN).parseDateTime(dateFormat);
    }

    public static DateTime yyyyMMddDash(String dateFormat) {
        return DateUtil.getDateTimeFormatter(YYYYMMDD_DASH_PATTERN).parseDateTime(dateFormat);
    }

    public static DateTime yyyyMMddTime(String dateFormat) {
        return DateUtil.getDateTimeFormatter(YYYYMMDD_TIME_PATTERN).parseDateTime(dateFormat);
    }

    public static DateTime yyyyMMddTimes(String dateFormat) {
        return DateUtil.getDateTimeFormatter(YYYYMMDD_TIMES_PATTERN).parseDateTime(dateFormat);
    }

    public static int unixTime() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static Date dateTime(int unix) {
        return new Date((long)unix * 1000L);
    }

    public static int unixTime(Date date) {
        return date == null ? 0 : (int)(date.getTime() / 1000L);
    }

    public static long unixTimeLong() {
        return System.currentTimeMillis() / 1000L;
    }
}

