/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.io;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.jtech.marble.util.base.Platforms;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class FileUtil {
    public static byte[] toByteArray(File file) throws IOException {
        return Files.toByteArray((File)file);
    }

    public static String toString(File file) throws IOException {
        return Files.toString((File)file, (Charset)Charsets.UTF_8);
    }

    public static List<String> toLines(File file) throws IOException {
        return Files.readLines((File)file, (Charset)Charsets.UTF_8);
    }

    public static void write(CharSequence data, File file) throws IOException {
        Files.write((CharSequence)data, (File)file, (Charset)Charsets.UTF_8);
    }

    public static void append(CharSequence from, File to) throws IOException {
        Files.append((CharSequence)from, (File)to, (Charset)Charsets.UTF_8);
    }

    public static InputStream asInputStream(String fileName) throws IOException {
        return new FileInputStream(FileUtil.getFileByPath(fileName));
    }

    public static InputStream asInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    public static OutputStream asOututStream(String fileName) throws IOException {
        return new FileOutputStream(FileUtil.getFileByPath(fileName));
    }

    public static OutputStream asOututStream(File file) throws IOException {
        return new FileOutputStream(file);
    }

    public static BufferedReader asBufferedReader(String fileName) throws FileNotFoundException {
        return Files.newReader((File)FileUtil.getFileByPath(fileName), (Charset)Charsets.UTF_8);
    }

    public static BufferedWriter asBufferedWriter(String fileName) throws FileNotFoundException {
        return Files.newWriter((File)FileUtil.getFileByPath(fileName), (Charset)Charsets.UTF_8);
    }

    public static void copy(File from, File to) throws IOException {
        Validate.notNull((Object)from);
        Validate.notNull((Object)to);
        if (from.isDirectory()) {
            FileUtil.copyDir(from, to);
        } else {
            FileUtil.copyFile(from, to);
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        Validate.isTrue((boolean)FileUtil.isFileExists(from), (String)(from + " is not exist or not a file"), (Object[])new Object[0]);
        Validate.notNull((Object)to);
        Validate.isTrue((!FileUtil.isDirExists(to) ? 1 : 0) != 0, (String)(to + " is exist but it is a dir"), (Object[])new Object[0]);
        Files.copy((File)from, (File)to);
    }

    public static void copyDir(File from, File to) throws IOException {
        Validate.isTrue((boolean)FileUtil.isDirExists(from), (String)(from + " is not exist or not a dir"), (Object[])new Object[0]);
        Validate.notNull((Object)to);
        if (to.exists()) {
            Validate.isTrue((!to.isFile() ? 1 : 0) != 0, (String)(to + " is exist but it is a file"), (Object[])new Object[0]);
        } else {
            to.mkdirs();
        }
        File[] files = from.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (".".equals(name) || "..".equals(name)) continue;
                FileUtil.copy(files[i], new File(to, name));
            }
        }
    }

    public static void moveFile(File from, File to) throws IOException {
        Validate.isTrue((boolean)FileUtil.isFileExists(from), (String)(from + " is not exist or not a file"), (Object[])new Object[0]);
        Validate.notNull((Object)to);
        Validate.isTrue((!FileUtil.isDirExists(to) ? 1 : 0) != 0, (String)(to + " is  exist but it is a dir"), (Object[])new Object[0]);
        Files.move((File)from, (File)to);
    }

    public static void moveDir(File from, File to) throws IOException {
        Validate.isTrue((boolean)FileUtil.isDirExists(from), (String)(from + " is not exist or not a dir"), (Object[])new Object[0]);
        Validate.notNull((Object)to);
        Validate.isTrue((!FileUtil.isFileExists(to) ? 1 : 0) != 0, (String)(to + " is exist but it is a file"), (Object[])new Object[0]);
        boolean rename = from.renameTo(to);
        if (!rename) {
            if (to.getCanonicalPath().startsWith(from.getCanonicalPath() + File.separator)) {
                throw new IOException("Cannot move directory: " + from + " to a subdirectory of itself: " + to);
            }
            FileUtil.copyDir(from, to);
            FileUtil.deleteDir(from);
            if (from.exists()) {
                throw new IOException("Failed to delete original directory '" + from + "' after copy to '" + to + '\'');
            }
        }
    }

    public static void touch(String filePath) throws IOException {
        Files.touch((File)FileUtil.getFileByPath(filePath));
    }

    public static void touch(File file) throws IOException {
        Files.touch((File)file);
    }

    public static void deleteFile(File file) throws IOException {
        Validate.isTrue((boolean)FileUtil.isFileExists(file), (String)(file + " is not exist or not a file"), (Object[])new Object[0]);
        file.delete();
    }

    public static void deleteDir(File dir) {
        Validate.isTrue((boolean)FileUtil.isDirExists(dir), (String)(dir + " is not exist or not a dir"), (Object[])new Object[0]);
        Iterator iterator = Files.fileTreeTraverser().postOrderTraversal((Object)dir).iterator();
        while (iterator.hasNext()) {
            ((File)iterator.next()).delete();
        }
    }

    public static boolean isDirExists(String dirPath) {
        return FileUtil.isDirExists(FileUtil.getFileByPath(dirPath));
    }

    public static boolean isDirExists(File dir) {
        if (dir == null) {
            return false;
        }
        return dir.exists() && dir.isDirectory();
    }

    public static void makesureDirExists(String dirPath) throws IOException {
        FileUtil.makesureDirExists(FileUtil.getFileByPath(dirPath));
    }

    public static void makesureDirExists(File file) throws IOException {
        Validate.notNull((Object)file);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("There is a file exists " + file);
            }
        } else {
            file.mkdirs();
        }
    }

    public static void makesureParentDirExists(File file) throws IOException {
        Files.createParentDirs((File)file);
    }

    public static boolean isFileExists(String fileName) {
        return FileUtil.isFileExists(FileUtil.getFileByPath(fileName));
    }

    public static boolean isFileExists(File file) {
        if (file == null) {
            return false;
        }
        return file.exists() && file.isFile();
    }

    public static File createTempDir() {
        return Files.createTempDir();
    }

    public static File createTempFile() throws IOException {
        return File.createTempFile("tmp-", ".tmp");
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix);
    }

    private static File getFileByPath(String filePath) {
        return StringUtils.isBlank((CharSequence)filePath) ? null : new File(filePath);
    }

    public static String getFileName(String fullName) {
        Validate.notEmpty((CharSequence)fullName);
        int last = fullName.lastIndexOf(Platforms.FILE_PATH_SEPARATOR_CHAR);
        return fullName.substring(last + 1);
    }

    public static String getFileExtension(File file) {
        return Files.getFileExtension((String)file.getName());
    }

    public static String getFileExtension(String fullName) {
        return Files.getFileExtension((String)fullName);
    }
}

