/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.io;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.jtech.marble.util.io.FileUtil;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageUtil.class);

    private ImageUtil() {
    }

    public static boolean isImage(String fileType) {
        return !Strings.isNullOrEmpty((String)fileType) && (StringUtils.equals((CharSequence)fileType, (CharSequence)"bmp") || StringUtils.equals((CharSequence)fileType, (CharSequence)"gif") || StringUtils.equals((CharSequence)fileType, (CharSequence)"jpg") || StringUtils.equals((CharSequence)fileType, (CharSequence)"jpeg") || StringUtils.equals((CharSequence)fileType, (CharSequence)"png"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Dimension> dimension(File imgFile) throws IOException {
        if (imgFile == null) {
            return Optional.absent();
        }
        if (!FileUtil.isFileExists(imgFile)) {
            return Optional.absent();
        }
        String type = com.xiaoleilu.hutool.io.FileUtil.getType((File)imgFile);
        if (Strings.isNullOrEmpty((String)type)) {
            LOGGER.error("Cannot find the file type!");
            throw new IOException("No extension for file: " + imgFile.getAbsolutePath());
        }
        if (!ImageUtil.isImage(type)) {
            LOGGER.error("The file type is {}, not image!", (Object)type);
            return Optional.absent();
        }
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(type);
        while (iter.hasNext()) {
            ImageReader reader = iter.next();
            try {
                FileImageInputStream stream = new FileImageInputStream(imgFile);
                reader.setInput(stream);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Optional optional = Optional.of((Object)new Dimension(width, height));
                return optional;
            }
            catch (IOException e) {
                LOGGER.warn("Error reading: " + imgFile.getAbsolutePath(), (Throwable)e);
            }
            finally {
                reader.dispose();
            }
        }
        throw new IOException("Not a known image file: " + imgFile.getAbsolutePath());
    }
}

