/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2017
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jtech.marble.error;

import org.apache.commons.lang3.StringUtils;

/**
 * <p> 错误信息Model </p>
 *
 * @author sog
 * @version 1.0
 * @since JDK 1.7
 */
@SuppressWarnings("unused")
public class ErrorModel {

    /**
     * 错误代码
     */
    private final int code;

    /**
     * 消息提醒
     */
    private final String message;

    private ErrorModel(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public static Builder builder() {
        return new Builder();
    }


    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public static class Builder {
        private ErrorCode errorCode;
        private String message = StringUtils.EMPTY;

        Builder() {
        }

        public Builder setCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public ErrorModel createErrorModel() {
            return new ErrorModel(errorCode.getCode(), message);
        }
    }
}
