/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2017
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jtech.marble.shiro.freemarker.permission;


import com.jtech.marble.StringPool;

import org.apache.shiro.subject.Subject;

/**
 * <p> A plurality of permission, as long as the only one. </p> <p/> Note: From the <a
 * href="https://github.com/springside/springside4">SpringSide4</a>
 *
 * @author sogYF
 * @version 1.0
 * @since JDK 1.6
 */
public class HasAnyPermissionsTag extends PermissionTag {
    @Override
    protected boolean showTagBody(String permissionNames) {
        boolean hasAnyPermission = false;

        Subject subject = getSubject();

        if (subject != null) {
            // Iterate through permissions and check to see if the user has one of the permissions
            for (String permission : permissionNames.split(StringPool.COMMA)) {

                if (subject.isPermitted(permission.trim())) {
                    hasAnyPermission = true;
                    break;
                }

            }
        }

        return hasAnyPermission;
    }
}
