/*
 * The Hefei JingTong RDC(Research and Development Centre) Group.
 * __________________
 *
 *    Copyright 2015-2017
 *    All Rights Reserved.
 *
 *    NOTICE:  All information contained herein is, and remains
 *    the property of JingTong Company and its suppliers,
 *    if any.
 */

package com.jtech.marble.shiro.freemarker.role;

import org.apache.shiro.subject.Subject;

/**
 * <p> 判定当前登录人是否有某个角色信息.如果有，则返回true </p>
 *
 * @author poplar.yfyang
 * @version 1.0 2012-10-27 10:38 AM
 * @since JDK 1.5
 */
public class HasRoleTag extends RoleTag {
    @Override
    protected boolean showTagBody(String roleName) {
        final Subject subject = getSubject();
        return subject != null && subject.hasRole(roleName);
    }
}
