package com.jtech.marble.util.text;

import com.alibaba.fastjson.JSON;

import static com.alibaba.fastjson.serializer.SerializerFeature.DisableCircularReferenceDetect;

/**
 * <p> 在FastJSON的基础上对其一些常用的功能进行工具化支持 </p>
 *
 * @author sog
 * @version 1.0
 * @since JDK 1.7
 */
public class JsonUtil {

    private JsonUtil() {
    }


    /**
     * JSON转换的时候不进行ref处理
     *
     * @param object 要处理的对象
     * @return 字符串
     */
    public static String toJsonWithoutRef(Object object) {
        return JSON.toJSONString(object, DisableCircularReferenceDetect);
    }
}
