/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.marble.util.text;

import com.google.common.base.Utf8;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class MoreStringUtil {
    public static List<String> split(String str, char separatorChar, int expectParts) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(expectParts);
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list;
    }

    public static String replaceFirst(String s, char sub, char with) {
        if (s == null) {
            return null;
        }
        int index = s.indexOf(sub);
        if (index == -1) {
            return s;
        }
        char[] str = s.toCharArray();
        str[index] = with;
        return new String(str);
    }

    public static String replaceLast(String s, char sub, char with) {
        if (s == null) {
            return null;
        }
        int index = s.lastIndexOf(sub);
        if (index == -1) {
            return s;
        }
        char[] str = s.toCharArray();
        str[index] = with;
        return new String(str);
    }

    public static boolean startWith(CharSequence s, char c) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return false;
        }
        return s.charAt(0) == c;
    }

    public static boolean endWith(CharSequence s, char c) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return false;
        }
        return s.charAt(s.length() - 1) == c;
    }

    public static String removeEnd(String s, char c) {
        if (MoreStringUtil.endWith(s, c)) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static int utf8EncodedLength(CharSequence sequence) {
        if (StringUtils.isEmpty((CharSequence)sequence)) {
            return 0;
        }
        return Utf8.encodedLength((CharSequence)sequence);
    }
}

