/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.auth.handler;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import com.jtech.toa.auth.handler.annotation.RequestUser;
import com.jtech.toa.auth.model.dto.RequestUserDto;
import com.jtech.toa.auth.service.IUserAccountService;
import com.jtech.toa.sys.domain.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@Component
public class UserMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final Logger logger = LoggerFactory.getLogger(UserMethodArgumentResolver.class);
    private final IUserAccountService userAccountService;

    @Autowired
    public UserMethodArgumentResolver(IUserAccountService userAccountService) {
        this.userAccountService = userAccountService;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterType().isAssignableFrom(RequestUserDto.class) && parameter.hasParameterAnnotation(RequestUser.class);
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest webRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        Object reqUserId = webRequest.getAttribute("TOA_REQUEST_CURRENT_KEY", 0);
        if (reqUserId != null) {
            long userId = ((Integer)MoreObjects.firstNonNull((Object)Ints.tryParse((String)String.valueOf(reqUserId)), (Object)0)).intValue();
            User loginUser = this.userAccountService.findByUserId(userId);
            if (loginUser != null) {
                logger.debug("Request User is {}", (Object)loginUser);
                RequestUserDto requestUserDto = new RequestUserDto();
                requestUserDto.setUserName(loginUser.getUsername());
                requestUserDto.setId(loginUser.getId());
                requestUserDto.setPhone(loginUser.getPhone());
                return requestUserDto;
            }
            throw new MissingServletRequestPartException("TOA_REQUEST_CURRENT_KEY");
        }
        return null;
    }
}

