/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.auth.service.impl;

import com.google.common.base.Optional;
import com.jtech.marble.util.PasswordUtil;
import com.jtech.toa.auth.exception.PasswordErrorException;
import com.jtech.toa.auth.model.dto.AccountLoginDTO;
import com.jtech.toa.auth.service.IJwtTokenService;
import com.jtech.toa.auth.service.IUserAccountService;
import com.jtech.toa.sys.domain.User;
import com.jtech.toa.sys.exception.UserNotFoundException;
import com.jtech.toa.sys.service.IUserService;
import com.jtech.toa.user.domain.Employee;
import com.jtech.toa.user.service.IEmployeeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Service;

@Service
public class UserAccountServiceImpl
implements IUserAccountService {
    public static final String TOKEN_UAT = "uat:";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAccountServiceImpl.class);
    private final IUserService userService;
    private final IEmployeeService employeeService;
    private final IJwtTokenService jwtTokenService;
    private final RedisTemplate<String, String> tokenCacheRedis;

    @Autowired
    public UserAccountServiceImpl(IUserService userService, IEmployeeService employeeService, IJwtTokenService jwtTokenService, RedisTemplate<String, String> tokenCacheRedis) {
        this.userService = userService;
        this.employeeService = employeeService;
        this.jwtTokenService = jwtTokenService;
        this.tokenCacheRedis = tokenCacheRedis;
    }

    @Override
    @CacheEvict(value={"login-user-cache"}, key="#userId")
    public void logout(long userId) {
        boolean tokenExist = this.tokenCacheRedis.hasKey((Object)(TOKEN_UAT + userId));
        if (tokenExist) {
            LOGGER.info("User {} logout token has remove!", (Object)userId);
            this.tokenCacheRedis.delete((Object)(TOKEN_UAT + userId));
        } else {
            LOGGER.info("User {} token not exist!", (Object)userId);
        }
    }

    @Override
    public AccountLoginDTO login(String username, String password, boolean rememberMe) {
        String token;
        String userPassword;
        Optional userOpt = this.userService.findByUsername(username);
        if (!userOpt.isPresent()) {
            throw new UserNotFoundException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        User user = (User)userOpt.get();
        String userSalt = user.getSalt();
        boolean checkPassword = PasswordUtil.checkPassword((String)userSalt, (String)(userPassword = user.getPassword()), (String)password);
        if (!checkPassword) {
            throw new PasswordErrorException("\u5bc6\u7801\u9519\u8bef");
        }
        long userId = user.getId();
        Employee employee = this.employeeService.selectByUserId(userId);
        AccountLoginDTO loginDTO = new AccountLoginDTO();
        loginDTO.setUserId(userId);
        loginDTO.setUsername(user.getUsername());
        loginDTO.setUserType(user.getUserType());
        if (employee != null) {
            loginDTO.setName(employee.getUsername());
            loginDTO.setAvatar(employee.getAvatar());
        }
        int expiresDays = 30;
        if (rememberMe) {
            expiresDays = 90;
            token = this.jwtTokenService.createToken(userId, expiresDays);
        } else {
            token = this.jwtTokenService.createToken(userId, expiresDays);
        }
        ValueOperations tokenValueOper = this.tokenCacheRedis.opsForValue();
        tokenValueOper.set((Object)(TOKEN_UAT + userId), (Object)token);
        loginDTO.setToken(token);
        return loginDTO;
    }

    @Override
    @Cacheable(value={"login-user-cache"}, key="#userId")
    public User findByUserId(long userId) {
        Optional userOpt = this.userService.findByUserId(userId);
        if (userOpt.isPresent()) {
            return (User)userOpt.get();
        }
        return null;
    }
}

