/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.bill.controller.api;

import com.jtech.marble.error.ErrorCode;
import com.jtech.marble.exception.ParamCheckException;
import com.jtech.toa.auth.handler.annotation.RequestUser;
import com.jtech.toa.auth.model.dto.RequestUserDto;
import com.jtech.toa.bill.manager.IBillManager;
import com.jtech.toa.bill.model.vo.BillDetailVO;
import com.jtech.toa.process.constants.ProcessCode;
import com.jtech.toa.sys.exception.UserNotFoundException;
import com.jtech.toa.user.domain.Employee;
import com.jtech.toa.user.service.IEmployeeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bill/detail"})
public class DetailController {
    private final IBillManager billManager;
    private final IEmployeeService employeeService;

    @Autowired
    public DetailController(IBillManager billManager, IEmployeeService employeeService) {
        this.billManager = billManager;
        this.employeeService = employeeService;
    }

    @GetMapping(value={"create/{processId}"})
    public ResponseEntity create(@PathVariable(value="processId") long processId, @RequestUser RequestUserDto requestUser) {
        if (processId <= 0L) {
            throw new ParamCheckException((ErrorCode)ProcessCode.PROCESS_ID_REQUIRED);
        }
        long userId = requestUser.getId();
        Employee employee = this.employeeService.selectByUserId(userId);
        if (employee == null) {
            throw new UserNotFoundException("\u5458\u5de5\u65e0\u6cd5\u627e\u5230");
        }
        BillDetailVO billDetailVO = this.billManager.create(processId, employee);
        return ResponseEntity.ok((Object)billDetailVO);
    }
}

