/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.bill.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Strings;
import com.jtech.marble.error.ErrorCode;
import com.jtech.marble.error.ErrorModel;
import com.jtech.marble.exception.ParamCheckException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.shiro.ShiroUtil;
import com.jtech.toa.bill.manager.IBillManager;
import com.jtech.toa.process.constants.ProcessCode;
import com.jtech.toa.process.model.dto.ProcessDetailDTO;
import com.jtech.toa.process.service.IProcessService;
import com.jtech.toa.sys.constants.CommonConst;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/bill/flow"})
public class FlowController {
    private final IBillManager billManager;
    private final IProcessService processService;

    @Autowired
    public FlowController(IBillManager billManager, IProcessService processService) {
        this.billManager = billManager;
        this.processService = processService;
    }

    @PostMapping(value={"drafts"})
    public ResponseEntity drafts(@RequestParam(value="processId") long processId, @RequestParam(value="formData") String formData) {
        if (processId <= 0L) {
            throw new ParamCheckException((ErrorCode)ProcessCode.PROCESS_ID_REQUIRED);
        }
        if (Strings.isNullOrEmpty((String)formData)) {
            throw new ParamCheckException((ErrorCode)ProcessCode.BILL_FORM_DATA_EMPTY);
        }
        Map formDataMap = (Map)JSON.parseObject((String)formData, (TypeReference)CommonConst.TF_MAP_STR_OBJ, (Feature[])new Feature[0]);
        formDataMap.put("__raw__", formData);
        ProcessDetailDTO process = this.processService.selectDetailById(processId);
        if (process == null) {
            ErrorModel errorModel = ErrorModel.builder().setCode((ErrorCode)ProcessCode.BILL_SAVE_PROCESS_NIL).setMessage("\u6d41\u7a0b\u65e0\u6cd5\u627e\u5230").createErrorModel();
            return ResponseEntity.badRequest().body((Object)errorModel);
        }
        if (process.getStatus() != 1) {
            ErrorModel errorModel = ErrorModel.builder().setCode((ErrorCode)ProcessCode.BILL_PROCESS_NOT_USED).setMessage("\u6d41\u7a0b\u672a\u542f\u7528").createErrorModel();
            return ResponseEntity.badRequest().body((Object)errorModel);
        }
        ShiroUser loginUser = ShiroUtil.getUser();
        this.billManager.saveDrafts(process, formDataMap, loginUser);
        return ResponseEntity.ok((Object)"");
    }

    @PostMapping(value={"submit"})
    public ResponseEntity submit(@RequestParam(value="processId") long processId, @RequestParam(value="formData") String formData) {
        if (processId <= 0L) {
            throw new ParamCheckException((ErrorCode)ProcessCode.PROCESS_ID_REQUIRED);
        }
        if (Strings.isNullOrEmpty((String)formData)) {
            throw new ParamCheckException((ErrorCode)ProcessCode.BILL_FORM_DATA_EMPTY);
        }
        Map formDataMap = (Map)JSON.parseObject((String)formData, (TypeReference)CommonConst.TF_MAP_STR_OBJ, (Feature[])new Feature[0]);
        formDataMap.put("__raw__", formData);
        ProcessDetailDTO process = this.processService.selectDetailById(processId);
        if (process == null) {
            ErrorModel errorModel = ErrorModel.builder().setCode((ErrorCode)ProcessCode.BILL_SAVE_PROCESS_NIL).setMessage("\u6d41\u7a0b\u65e0\u6cd5\u627e\u5230").createErrorModel();
            return ResponseEntity.badRequest().body((Object)errorModel);
        }
        if (process.getStatus() != 1) {
            ErrorModel errorModel = ErrorModel.builder().setCode((ErrorCode)ProcessCode.BILL_PROCESS_NOT_USED).setMessage("\u6d41\u7a0b\u672a\u542f\u7528").createErrorModel();
            return ResponseEntity.badRequest().body((Object)errorModel);
        }
        ShiroUser loginUser = ShiroUtil.getUser();
        this.billManager.submitFlow(process, formDataMap, loginUser);
        return ResponseEntity.ok((Object)"");
    }
}

