/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.bill.manager.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jtech.marble.error.ErrorCode;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.marble.util.text.StrUtil;
import com.jtech.toa.bill.domain.Bill;
import com.jtech.toa.bill.domain.BillItem;
import com.jtech.toa.bill.manager.IBillBpmnManager;
import com.jtech.toa.bill.manager.IBillManager;
import com.jtech.toa.bill.model.vo.BillDetailVO;
import com.jtech.toa.bill.service.IBillItemService;
import com.jtech.toa.bill.service.IBillService;
import com.jtech.toa.form.constants.FormValueType;
import com.jtech.toa.form.domain.FormDesinger;
import com.jtech.toa.form.domain.FormField;
import com.jtech.toa.form.model.define.FormXtype;
import com.jtech.toa.form.model.vo.FormFieldVO;
import com.jtech.toa.form.model.vo.FormPermissionVO;
import com.jtech.toa.form.service.IFormService;
import com.jtech.toa.process.constants.ProcessCode;
import com.jtech.toa.process.domain.NodeFormField;
import com.jtech.toa.process.exception.ProcessBizException;
import com.jtech.toa.process.model.dto.ProcessDetailDTO;
import com.jtech.toa.process.service.IBillTitleService;
import com.jtech.toa.process.service.INodeFormFieldService;
import com.jtech.toa.process.service.IProcessService;
import com.jtech.toa.sys.manager.ICodeManager;
import com.jtech.toa.user.domain.Employee;
import com.xiaoleilu.hutool.date.DateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BillManagerImpl
implements IBillManager {
    private final IProcessService processService;
    private final IBillTitleService billTitleService;
    private final IBillService billService;
    private final INodeFormFieldService nodeFormFieldService;
    private final IBillItemService billItemService;
    private final ICodeManager codeManager;
    private final IFormService formService;
    private final IBillBpmnManager billBpmnManager;

    @Autowired
    public BillManagerImpl(IProcessService processService, IBillTitleService billTitleService, IBillService billService, INodeFormFieldService nodeFormFieldService, IBillItemService billItemService, ICodeManager codeManager, IFormService formService, IBillBpmnManager billBpmnManager) {
        this.processService = processService;
        this.billTitleService = billTitleService;
        this.billService = billService;
        this.nodeFormFieldService = nodeFormFieldService;
        this.billItemService = billItemService;
        this.codeManager = codeManager;
        this.formService = formService;
        this.billBpmnManager = billBpmnManager;
    }

    @Override
    public Bill saveDrafts(ProcessDetailDTO processDetail, Map<String, Object> formDataMap, ShiroUser loginUser) {
        Preconditions.checkNotNull((Object)processDetail);
        Preconditions.checkNotNull(formDataMap);
        String formDataJSON = String.valueOf(formDataMap.get("__raw__"));
        long processId = (Long)MoreObjects.firstNonNull((Object)processDetail.getId(), (Object)0L);
        Bill bill = this.createBill(processDetail, loginUser, 0);
        boolean insertState = this.billService.insert((Object)bill);
        if (insertState) {
            this.billService.saveDataByProcessId(processId, formDataJSON, bill);
            List<BillItem> billItems = this.parseItem(bill, formDataMap);
            boolean batchState = this.billItemService.insertBatch(billItems);
            if (!batchState) {
                throw new DaoException("\u4fdd\u5b58\u5931\u8d25");
            }
        }
        return bill;
    }

    @Override
    public Bill submitFlow(ProcessDetailDTO processDetail, Map<String, Object> formDataMap, ShiroUser loginUser) {
        Preconditions.checkNotNull((Object)processDetail);
        Preconditions.checkNotNull(formDataMap);
        String formDataJSON = String.valueOf(formDataMap.get("__raw__"));
        long processId = (Long)MoreObjects.firstNonNull((Object)processDetail.getId(), (Object)0L);
        Bill bill = this.createBill(processDetail, loginUser, 0);
        boolean insertState = this.billService.insert((Object)bill);
        if (insertState) {
            this.billService.saveDataByProcessId(processId, formDataJSON, bill);
            List<BillItem> billItems = this.parseItem(bill, formDataMap);
            boolean batchState = this.billItemService.insertBatch(billItems);
            if (!batchState) {
                throw new DaoException("\u4fdd\u5b58\u5931\u8d25");
            }
            String flowId = processDetail.getFlowId();
            this.billBpmnManager.startFlow(flowId);
        }
        return bill;
    }

    @Override
    public BillDetailVO create(long processId, Employee employee) {
        ProcessDetailDTO process = this.processService.selectDetailById(processId);
        if (process == null) {
            throw new ProcessBizException((ErrorCode)ProcessCode.BILL_SAVE_PROCESS_NIL);
        }
        if (process.getStatus() != 1) {
            throw new ProcessBizException((ErrorCode)ProcessCode.BILL_PROCESS_NOT_USED);
        }
        FormDesinger formDesinger = this.formService.findDesingerByProcessId(processId);
        String flowId = process.getFlowId();
        ArrayList opinionVOS = Lists.newArrayList();
        ProcessDefinition processDefinition = this.billBpmnManager.findLastVersionByFlowId(flowId);
        String firstNodeId = null;
        if (processDefinition != null) {
            String definitionId = processDefinition.getId();
            List<FlowElement> userTaskNodes = this.billBpmnManager.findNodesByType(definitionId, 2, UserTask.class);
            firstNodeId = userTaskNodes.get(0).getId();
        }
        List<FormPermissionVO> permissionVOS = this.nodeFieldPermission(processId, firstNodeId);
        String title = this.billTitleService.getTitle(processId, employee);
        FormField formField = this.formService.findFieldByValueType(FormValueType.billTitle);
        HashMap formData = Maps.newHashMap();
        if (formField != null) {
            formData.put(formField.getWidgetName(), title);
        }
        return BillDetailVO.builder().form(formDesinger.getDesingerJson()).formData(formData).opinions(opinionVOS).permission(permissionVOS).build();
    }

    private List<FormPermissionVO> nodeFieldPermission(long processId, String firstNodeId) {
        List nodeFormFields;
        if (!Strings.isNullOrEmpty((String)firstNodeId) && CollectionUtil.isNotEmpty((Collection)(nodeFormFields = this.nodeFormFieldService.selectByProcessIdAndNodeId(processId, firstNodeId)))) {
            ArrayList permissionVOS = Lists.newArrayList();
            for (NodeFormField nodeFormField : nodeFormFields) {
                FormPermissionVO permissionVO = new FormPermissionVO();
                permissionVO.setHidden(!nodeFormField.getVisibleFlag());
                permissionVO.setEdit(nodeFormField.getEditFlag());
                permissionVO.setWidgetName(nodeFormField.getFormWidgetName());
                permissionVOS.add(permissionVO);
            }
            return permissionVOS;
        }
        return Collections.emptyList();
    }

    private List<BillItem> parseItem(Bill bill, Map<String, Object> formDataMap) {
        Long processId = bill.getProcessId();
        List formFieldVOS = this.formService.findFieldByProcessId(processId.longValue());
        HashMap formFieldVOMap = Maps.newHashMap();
        for (FormFieldVO formFieldVO : formFieldVOS) {
            formFieldVOMap.put(formFieldVO.getWidgetName(), formFieldVO);
        }
        Long billId = bill.getId();
        ArrayList billItems = Lists.newArrayList();
        int sort = 1;
        for (String widgetName : formDataMap.keySet()) {
            FormFieldVO formFieldVO = (FormFieldVO)formFieldVOMap.get(widgetName);
            BillItem billItem = new BillItem();
            billItem.setBillId(billId);
            billItem.setFieldCode(formFieldVO.getWidgetName());
            billItem.setFieldId(formFieldVO.getId());
            billItem.setFieldName(formFieldVO.getTitle());
            String fieldType = formFieldVO.getType();
            billItem.setFieldType(fieldType);
            billItem.setSort(sort);
            Object widgetValue = formDataMap.get(widgetName);
            FormXtype formXtype = FormXtype.valueOf((String)fieldType);
            switch (formXtype) {
                case textarea: 
                case datetime: 
                case text: 
                case number: 
                case money: {
                    billItem.setDataVal(String.valueOf(widgetValue));
                    break;
                }
                case checkboxgroup: 
                case radiogroup: 
                case select: 
                case multiselect: 
                case location: 
                case triggerselect: 
                case imageupload: 
                case fileupload: {
                    billItem.setDataVal(JSON.toJSONString((Object)widgetValue));
                    break;
                }
            }
            billItems.add(billItem);
            ++sort;
        }
        return billItems;
    }

    private Bill createBill(ProcessDetailDTO processDetail, ShiroUser loginUser, int status) {
        Bill bill = new Bill();
        long processCodeId = (Long)MoreObjects.firstNonNull((Object)processDetail.getCodeId(), (Object)0L);
        if (processCodeId > 0L) {
            String code = this.codeManager.execCodeRule(processCodeId);
            bill.setCode(code);
        } else {
            String day = DateUtil.yyyyMMdd((Date)DateTime.now());
            String typeName = processDetail.getTypeCode();
            String randomStr = RandomStringUtils.randomNumeric((int)4);
            bill.setCode(StrUtil.format((String)"{}-{}-{}", (Object[])new Object[]{day, typeName, randomStr}));
        }
        int unixTime = DateUtil.unixTime();
        bill.setCodeRule(processCodeId);
        bill.setProcessId(processDetail.getId());
        bill.setCreater(loginUser.getId());
        bill.setCreateTime(unixTime);
        bill.setTitle("");
        bill.setStatus(status);
        bill.setSender(loginUser.getId());
        return bill;
    }
}

