/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.bill.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.bill.dao.BillTallyDailyMapper;
import com.jtech.toa.bill.domain.BillTallyDaily;
import com.jtech.toa.bill.service.IBillTallyDailyService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillTallyDailyServiceImpl
extends ServiceImpl<BillTallyDailyMapper, BillTallyDaily>
implements IBillTallyDailyService {
    @Override
    @Transactional(readOnly=true)
    public List<BillTallyDaily> selectByMonth(Integer dateYear, Integer dateMonth, long employeeId) {
        return ((BillTallyDailyMapper)this.baseMapper).selectByMonth(dateYear, dateMonth, employeeId);
    }

    @Override
    public boolean tallyDaily(long employeeId, Date date, BigDecimal amount) {
        int dayOfMonth;
        int monthOfYear;
        DateTime day = new DateTime((Object)date);
        int year = day.getYear();
        BillTallyDaily billTallyDaily = ((BillTallyDailyMapper)this.baseMapper).selectByDay(year, monthOfYear = day.getMonthOfYear(), dayOfMonth = day.getDayOfMonth(), employeeId);
        if (billTallyDaily == null) {
            billTallyDaily = new BillTallyDaily();
            billTallyDaily.setEmployeeId(employeeId);
            billTallyDaily.setCreater(employeeId);
            billTallyDaily.setAmount(amount);
            billTallyDaily.setCreateTime(DateUtil.unixTime());
            billTallyDaily.setDateline(DateUtil.unixTime((Date)date));
            billTallyDaily.setDateYear(year);
            billTallyDaily.setDateMonth(monthOfYear);
            billTallyDaily.setDateDay(dayOfMonth);
            return ((BillTallyDailyMapper)this.baseMapper).insert((Object)billTallyDaily) > 0;
        }
        billTallyDaily.setUpdater(employeeId);
        billTallyDaily.setUpdateTime(DateUtil.unixTime());
        BigDecimal newAmount = billTallyDaily.getAmount().add(amount);
        billTallyDaily.setAmount(newAmount);
        return ((BillTallyDailyMapper)this.baseMapper).updateById((Object)billTallyDaily) > 0;
    }
}

