/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.config.properties;

import com.google.common.io.Files;
import com.xiaoleilu.hutool.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="oa")
public class OaProperties {
    public static final String PREFIX = "oa";
    private static final Logger LOGGER = LoggerFactory.getLogger(OaProperties.class);
    private Boolean kaptchaOpen = false;
    private String fileUploadPath;
    private Boolean haveCreatePath = false;
    private Integer sessionInvalidateTime = 1800;
    private Integer sessionValidationInterval = 900;
    private boolean shiro = false;
    private int tokenExpiresDay = 30;
    private Integer adminResource = 2;
    private Integer portalResource = 1;

    public String getFileUploadPath() {
        if (StringUtils.isEmpty((CharSequence)this.fileUploadPath)) {
            return System.getProperty("java.io.tmpdir");
        }
        if (!this.fileUploadPath.endsWith(File.separator)) {
            this.fileUploadPath = this.fileUploadPath + File.separator;
        }
        this.haveCreatePath = FileUtil.exist((String)this.fileUploadPath);
        if (!this.haveCreatePath.booleanValue()) {
            File file = new File(this.fileUploadPath + "cp.txt");
            try {
                Files.createParentDirs((File)file);
            }
            catch (IOException e) {
                return System.getProperty("java.io.tmpdir");
            }
            this.haveCreatePath = true;
        }
        return this.fileUploadPath;
    }

    public void setFileUploadPath(String fileUploadPath) {
        this.fileUploadPath = fileUploadPath;
    }

    public Boolean getKaptchaOpen() {
        return this.kaptchaOpen;
    }

    public void setKaptchaOpen(Boolean kaptchaOpen) {
        this.kaptchaOpen = kaptchaOpen;
    }

    public Integer getSessionInvalidateTime() {
        return this.sessionInvalidateTime;
    }

    public void setSessionInvalidateTime(Integer sessionInvalidateTime) {
        this.sessionInvalidateTime = sessionInvalidateTime;
    }

    public Integer getSessionValidationInterval() {
        return this.sessionValidationInterval;
    }

    public void setSessionValidationInterval(Integer sessionValidationInterval) {
        this.sessionValidationInterval = sessionValidationInterval;
    }

    public Integer getAdminResource() {
        return this.adminResource;
    }

    public void setAdminResource(Integer adminResource) {
        this.adminResource = adminResource;
    }

    public Integer getPortalResource() {
        return this.portalResource;
    }

    public void setPortalResource(Integer portalResource) {
        this.portalResource = portalResource;
    }

    public boolean isShiro() {
        return this.shiro;
    }

    public boolean getShiro() {
        return this.shiro;
    }

    public void setShiro(boolean shiro) {
        this.shiro = shiro;
    }

    public int getTokenExpiresDay() {
        return this.tokenExpiresDay;
    }

    public void setTokenExpiresDay(int tokenExpiresDay) {
        this.tokenExpiresDay = tokenExpiresDay;
    }
}

