/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.config.web;

import com.jtech.marble.freemarker.layout.BlockDirective;
import com.jtech.marble.freemarker.layout.ExtendsDirective;
import com.jtech.marble.freemarker.layout.OverrideDirective;
import com.jtech.marble.freemarker.layout.SuperDirective;
import com.jtech.marble.listener.ConfigListener;
import com.jtech.marble.shiro.freemarker.ShiroTags;
import com.jtech.toa.config.properties.OaProperties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

@Configuration
@DependsOn(value={"configListenerRegistration"})
public class FreemarkerConfig
extends FreeMarkerAutoConfiguration.FreeMarkerWebConfiguration {
    private final OaProperties oaProperties;

    @Autowired
    public FreemarkerConfig(OaProperties oaProperties) {
        this.oaProperties = oaProperties;
    }

    public FreeMarkerConfigurer freeMarkerConfigurer() {
        FreeMarkerConfigurer configurer = super.freeMarkerConfigurer();
        HashMap<String, Object> sharedVariables = new HashMap<String, Object>();
        sharedVariables.put("block", new BlockDirective());
        sharedVariables.put("extends", new ExtendsDirective());
        sharedVariables.put("override", new OverrideDirective());
        sharedVariables.put("super", new SuperDirective());
        if (this.oaProperties.isShiro()) {
            sharedVariables.put("shiro", new ShiroTags());
        }
        Map conf = ConfigListener.getConf();
        sharedVariables.put("ctx", conf.get("ctx"));
        configurer.setFreemarkerVariables(sharedVariables);
        return configurer;
    }
}

