/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.form.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.jtech.marble.util.DateUtil;
import com.jtech.marble.util.text.StrUtil;
import com.jtech.toa.form.dao.FormScopeMapper;
import com.jtech.toa.form.domain.FormScope;
import com.jtech.toa.form.model.dto.FormScopeDto;
import com.jtech.toa.form.model.dto.FormSettingDto;
import com.jtech.toa.form.service.IFormScopeService;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormScopeServiceImpl
extends ServiceImpl<FormScopeMapper, FormScope>
implements IFormScopeService {
    @Override
    @Transactional(readOnly=true)
    public int getAllseeingByFormId(long id) {
        return ((FormScopeMapper)this.baseMapper).getAllseeingByFormId(id);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FormScopeDto> findUserByFormId(long id) {
        return ((FormScopeMapper)this.baseMapper).findUserByFormId(id);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FormScopeDto> findOrgByFormId(long id) {
        return ((FormScopeMapper)this.baseMapper).findOrgByFormId(id);
    }

    @Override
    public boolean updateFormScope(long loginUserId, FormSettingDto formSettingDto) {
        FormScope formScope;
        int delete = ((FormScopeMapper)this.baseMapper).deleteByFormId(formSettingDto.getId());
        if (formSettingDto.getRangeType() == 3) {
            FormScope formScope2 = new FormScope();
            formScope2.setFormId(formSettingDto.getId());
            formScope2.setRangeType(3);
            formScope2.setCreater(loginUserId);
            formScope2.setCreateTime(DateUtil.unixTime());
            int insert = ((FormScopeMapper)this.baseMapper).insert((Object)formScope2);
            return insert == 1;
        }
        List empIds = StrUtil.split((String)formSettingDto.getScopeUserIds(), (String)",");
        for (String empId : empIds) {
            formScope = new FormScope();
            formScope.setFormId(formSettingDto.getId());
            formScope.setRangeType(2);
            formScope.setUserId(Long.valueOf(empId));
            formScope.setCreater(loginUserId);
            formScope.setCreateTime(DateUtil.unixTime());
            int insert = ((FormScopeMapper)this.baseMapper).insert((Object)formScope);
            if (insert == 1) continue;
            return false;
        }
        List orgIds = StrUtil.split((String)formSettingDto.getScopeDepIds(), (String)",");
        for (String orgId : orgIds) {
            formScope = new FormScope();
            formScope.setFormId(formSettingDto.getId());
            formScope.setRangeType(1);
            formScope.setDepartmentId(Long.valueOf(orgId));
            formScope.setCreater(loginUserId);
            formScope.setCreateTime(DateUtil.unixTime());
            int insert = ((FormScopeMapper)this.baseMapper).insert((Object)formScope);
            if (insert == 1) continue;
            return false;
        }
        return true;
    }
}

