/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.form.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.toolkit.IdWorker;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jtech.marble.exception.DaoException;
import com.jtech.marble.shiro.ShiroUser;
import com.jtech.marble.util.CollectionUtil;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.form.constants.FormValueType;
import com.jtech.toa.form.dao.FormMapper;
import com.jtech.toa.form.domain.Form;
import com.jtech.toa.form.domain.FormDesinger;
import com.jtech.toa.form.domain.FormField;
import com.jtech.toa.form.domain.FormSetting;
import com.jtech.toa.form.model.define.FormXtype;
import com.jtech.toa.form.model.dto.FormAttrDto;
import com.jtech.toa.form.model.dto.FormColumnDto;
import com.jtech.toa.form.model.dto.FormScopeDto;
import com.jtech.toa.form.model.dto.FormSettingDto;
import com.jtech.toa.form.model.dto.widget.FormWidgetDto;
import com.jtech.toa.form.model.vo.FormFieldVO;
import com.jtech.toa.form.service.IFormDesingerService;
import com.jtech.toa.form.service.IFormFieldService;
import com.jtech.toa.form.service.IFormScopeService;
import com.jtech.toa.form.service.IFormService;
import com.jtech.toa.form.service.IFormSettingService;
import com.xiaoleilu.hutool.date.DateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormServiceImpl
extends ServiceImpl<FormMapper, Form>
implements IFormService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormServiceImpl.class);
    private final IFormFieldService formFieldService;
    private final IFormScopeService formScopeService;
    private final IFormSettingService formSettingService;
    private final IFormDesingerService formDesingerService;

    @Autowired
    public FormServiceImpl(IFormFieldService formFieldService, IFormScopeService formScopeService, IFormSettingService formSettingService, IFormDesingerService formDesingerService) {
        this.formFieldService = formFieldService;
        this.formScopeService = formScopeService;
        this.formSettingService = formSettingService;
        this.formDesingerService = formDesingerService;
    }

    @Override
    public FormDesinger findDesingerByProcessId(long processId) {
        if (processId <= 0L) {
            return null;
        }
        return this.formDesingerService.selectByProcessId(processId);
    }

    @Override
    @Transactional(readOnly=true)
    public Form selectByProcessId(long processId) {
        return ((FormMapper)this.baseMapper).selectByProcessId(processId);
    }

    @Override
    @Transactional(readOnly=true)
    public FormField findFieldByValueType(FormValueType billTitle) {
        if (billTitle == null) {
            return null;
        }
        return this.formFieldService.selectByValueType(billTitle);
    }

    @Override
    @Transactional(readOnly=true)
    public List<FormFieldVO> findFieldByProcessId(long processId) {
        if (processId <= 0L) {
            return Collections.emptyList();
        }
        return this.formFieldService.selectByProcesId(processId);
    }

    @Override
    @Transactional(readOnly=true)
    public FormSettingDto getFormSettingDto(long processId) {
        int res;
        Form form = ((FormMapper)this.baseMapper).selectByProcessId(processId);
        if (form == null) {
            return null;
        }
        FormSetting formSetting = this.formSettingService.selectByFormId(form.getId());
        FormSettingDto formSettingDto = new FormSettingDto();
        formSettingDto.setId(form.getId());
        formSettingDto.setProcessId(form.getProcessId());
        formSettingDto.setDocumentation(form.getDocumentation());
        if (formSetting != null) {
            formSettingDto.setFormLink(formSetting.getFormLink());
            formSettingDto.setPrintTemplateUrl(formSetting.getPrintTemplateUrl());
            formSettingDto.setPushType(formSetting.getPushType());
        }
        if ((res = this.formScopeService.getAllseeingByFormId(form.getId())) == 0) {
            int i;
            List<FormScopeDto> formUserScopeDtos = this.formScopeService.findUserByFormId(form.getId());
            List<FormScopeDto> formOrgScopeDtos = this.formScopeService.findOrgByFormId(form.getId());
            StringBuilder receiveNames = new StringBuilder();
            if (formOrgScopeDtos.size() > 0) {
                StringBuilder orgIds = new StringBuilder();
                for (i = 0; i < formOrgScopeDtos.size(); ++i) {
                    if (i == formOrgScopeDtos.size() - 1) {
                        receiveNames.append(formOrgScopeDtos.get(i).getDepName());
                        orgIds.append(formOrgScopeDtos.get(i).getDepartmentId());
                        continue;
                    }
                    receiveNames.append(formOrgScopeDtos.get(i).getDepName()).append(",");
                    orgIds.append(formOrgScopeDtos.get(i).getDepartmentId()).append(",");
                }
                formSettingDto.setScopeDepIds(orgIds.toString());
            }
            if (formUserScopeDtos.size() > 0) {
                if (formOrgScopeDtos.size() > 0) {
                    receiveNames.append(",");
                }
                StringBuilder userIds = new StringBuilder();
                for (i = 0; i < formUserScopeDtos.size(); ++i) {
                    if (i == formUserScopeDtos.size() - 1) {
                        receiveNames.append(formUserScopeDtos.get(i).getUserName());
                        userIds.append(formUserScopeDtos.get(i).getUserId());
                        continue;
                    }
                    receiveNames.append(formUserScopeDtos.get(i).getUserName()).append(",");
                    userIds.append(formUserScopeDtos.get(i).getUserId()).append(",");
                }
                formSettingDto.setScopeUserIds(userIds.toString());
            }
            formSettingDto.setScopeNames(receiveNames.toString());
            formSettingDto.setRangeType(0);
        } else {
            formSettingDto.setPushType(3);
        }
        return formSettingDto;
    }

    @Override
    @Transactional
    public Form saveFormAttr(FormAttrDto formAttr, long processId, ShiroUser shiroUser) {
        boolean state;
        int unixTime = DateUtil.unixTime();
        long longUserId = shiroUser.getId();
        Form form = ((FormMapper)this.baseMapper).selectByProcessId(processId);
        if (form == null) {
            form = new Form();
            form.setCreater(longUserId);
            form.setCreateTime(unixTime);
            form.setProcessFlag(true);
            form.setProcessId(processId);
            form.setClientAppFlag(false);
            form.setCode(DateUtil.yyyyMMdd((Date)DateTime.now()) + RandomStringUtils.randomNumeric((int)4));
            form.setDescription(formAttr.getDescription());
            if (formAttr.getIcon() > 0L) {
                form.setIcon(String.valueOf(formAttr.getIcon()));
            }
            form.setLayout(formAttr.getLayout().getColgroup().size());
            form.setName(formAttr.getName());
            form.setSort(1);
            form.setDocumentation("");
            form.setUpdateTime(0);
            form.setUpdater(0L);
            form.setStyle(JSON.toJSONString((Object)formAttr.getStyle()));
            int insertRows = ((FormMapper)this.baseMapper).insert((Object)form);
            state = insertRows > 0;
        } else {
            form.setUpdater(longUserId);
            form.setUpdateTime(unixTime);
            form.setDescription(formAttr.getDescription());
            if (formAttr.getIcon() > 0L) {
                form.setIcon(String.valueOf(formAttr.getIcon()));
            }
            form.setLayout(formAttr.getLayout().getColgroup().size());
            form.setName(formAttr.getName());
            int updateRows = ((FormMapper)this.baseMapper).updateById((Object)form);
            boolean bl = state = updateRows > 0;
        }
        if (!state) {
            LOGGER.error("process from save error!");
            throw new DaoException("\u6570\u636e\u64cd\u4f5c\u5931\u8d25");
        }
        return form;
    }

    @Override
    @Transactional
    public void saveFromColumn(List<List<FormColumnDto>> columnItems, long formId, ShiroUser shiroUser) {
        int unixTime = DateUtil.unixTime();
        long loginUserId = shiroUser.getId();
        List<FormField> formFieldList = this.formFieldService.selectByFormId(formId);
        if (CollectionUtil.isNotEmpty(formFieldList)) {
            for (FormField formField : formFieldList) {
                formField.setDeleteFlag(true);
                formField.setUpdater(loginUserId);
                formField.setUpdateTime(unixTime);
            }
            boolean deleteState = this.formFieldService.updateBatchById(formFieldList);
            if (!deleteState) {
                LOGGER.error("form {} from column save has error!", (Object)formId);
                throw new DaoException("\u5b57\u6bb5\u4fdd\u5b58\u6709\u95ee\u9898!");
            }
        }
        ArrayList formFields = Lists.newArrayList();
        int sort = 1;
        for (List<FormColumnDto> columnItem : columnItems) {
            for (FormColumnDto formColumnDto : columnItem) {
                FormWidgetDto widget = formColumnDto.getWidget();
                if (widget == null) continue;
                FormXtype xtype = widget.getXtype();
                FormField formField = new FormField();
                formField.setTitle(widget.getTitle());
                formField.setWidgetName(widget.getWidgetName());
                formField.setFormId(formId);
                formField.setType(widget.getXtype().toString());
                formField.setDescription(widget.getDescription());
                formField.setPlaceholder(widget.getPlaceholder());
                formField.setRequired(widget.isRequired());
                formField.setSort(sort);
                formField.setCreater(loginUserId);
                formField.setCreateTime(unixTime);
                formField.setProps(JSON.toJSONString((Object)formColumnDto));
                formFields.add(formField);
                switch (xtype) {
                    case detailgroup: {
                        long detailFiledId = IdWorker.getId();
                        formField.setId(detailFiledId);
                        List<FormField> detailFields = this.parseDetailgrid(widget, formId, detailFiledId, loginUserId);
                        if (!CollectionUtil.isNotEmpty(detailFields)) break;
                        formFields.addAll(detailFields);
                        break;
                    }
                }
            }
            ++sort;
        }
        if (CollectionUtil.isEmpty((Collection)formFields)) {
            return;
        }
        boolean fieldState = this.formFieldService.insertBatch(formFields);
        if (!fieldState) {
            LOGGER.error("form field save has error!");
            throw new DaoException("\u8868\u5355\u5b57\u6bb5\u62a5\u9519\u5931\u8d25");
        }
    }

    private List<FormField> parseDetailgrid(FormWidgetDto detailgroup, long formId, long detailFiledId, long loginUserId) {
        String formItems = detailgroup.getItems();
        if (Strings.isNullOrEmpty((String)formItems)) {
            return Collections.emptyList();
        }
        int unixTime = DateUtil.unixTime();
        ArrayList formFields = Lists.newArrayList();
        String detailgroupName = detailgroup.getTitle();
        List formWidgetDtos = JSON.parseArray((String)formItems, FormWidgetDto.class);
        int sort = 1;
        for (FormWidgetDto formWidget : formWidgetDtos) {
            FormField formField = new FormField();
            formField.setTitle(formWidget.getTitle());
            formField.setFormId(formId);
            formField.setWidgetName(formWidget.getWidgetName());
            formField.setType(formWidget.getXtype().toString());
            formField.setDescription(formWidget.getDescription());
            formField.setPlaceholder(formWidget.getPlaceholder());
            formField.setRequired(formWidget.isRequired());
            formField.setSort(sort);
            formField.setFieldId(detailFiledId);
            formField.setCreater(loginUserId);
            formField.setCreateTime(unixTime);
            formField.setProps(JSON.toJSONString((Object)formWidget));
            formFields.add(formField);
            ++sort;
        }
        return formFields;
    }
}

