/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.info.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Optional;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.info.dao.MeetingMapper;
import com.jtech.toa.info.domain.Meeting;
import com.jtech.toa.info.model.query.MeetingQuery;
import com.jtech.toa.info.model.vo.MeetingVo;
import com.jtech.toa.info.service.IMeetingService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeetingServiceImpl
extends ServiceImpl<MeetingMapper, Meeting>
implements IMeetingService {
    @Override
    public int removeMeeting(long id) {
        int res = ((Meeting)((Object)((MeetingMapper)this.baseMapper).selectById(Long.valueOf(id)))).getStatus();
        if (res != 2) {
            return ((MeetingMapper)this.baseMapper).deleteById(Long.valueOf(id));
        }
        return -1;
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<Meeting> findByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Optional.absent();
        }
        Meeting meeting = ((MeetingMapper)this.baseMapper).selectByName(name);
        if (meeting == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)meeting));
    }

    @Override
    public boolean addMeeting(Meeting meeting) {
        meeting.setCreateTime(DateUtil.unixTime());
        meeting.setDeleteFlag(0);
        return ((MeetingMapper)this.baseMapper).insert((Object)meeting) == 1;
    }

    @Override
    public boolean updateMeeting(Meeting meeting) {
        meeting.setUpdateTime(DateUtil.unixTime());
        return ((MeetingMapper)this.baseMapper).updateById((Object)meeting) == 1;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<Meeting> requestPage, MeetingQuery query) {
        List<Meeting> meetings = ((MeetingMapper)this.baseMapper).searchByPagination(requestPage, query);
        requestPage.setRecords(meetings);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Meeting> findByPagination(Page<Meeting> pageResult, List<Sort.Order> orders) {
        List<Meeting> meetings = ((MeetingMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(meetings);
        return pageResult;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<MeetingVo> selectByPageOrderByCreateTime(Page<MeetingVo> pageResult) {
        List<MeetingVo> meetings = ((MeetingMapper)this.baseMapper).selectByPageOrderByCreateTime(pageResult);
        pageResult.setRecords(meetings);
        return pageResult;
    }
}

