/*
 * Decompiled with CFR 0.152.
 */
package com.jtech.toa.info.service.impl;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.google.common.base.Optional;
import com.jtech.marble.util.DateUtil;
import com.jtech.toa.info.dao.NewsMapper;
import com.jtech.toa.info.domain.News;
import com.jtech.toa.info.domain.NewsContent;
import com.jtech.toa.info.model.NewsDto;
import com.jtech.toa.info.model.NewsReceiveDto;
import com.jtech.toa.info.model.query.NewsQuery;
import com.jtech.toa.info.model.vo.NewsDetailVo;
import com.jtech.toa.info.model.vo.NewsVo;
import com.jtech.toa.info.service.INewsContentService;
import com.jtech.toa.info.service.INewsReceiveService;
import com.jtech.toa.info.service.INewsService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NewsServiceImpl
extends ServiceImpl<NewsMapper, News>
implements INewsService {
    private final INewsContentService newsContentService;
    private final INewsReceiveService newsReceiveService;

    public NewsServiceImpl(INewsContentService newsContentService, INewsReceiveService newsReceiveService) {
        this.newsContentService = newsContentService;
        this.newsReceiveService = newsReceiveService;
    }

    @Override
    @Transactional(readOnly=true)
    public NewsDto getNewsDto(long id) {
        int i;
        News news = (News)((Object)((NewsMapper)this.baseMapper).selectById(Long.valueOf(id)));
        NewsContent newsContent = this.newsContentService.selectByNewsId(id);
        NewsDto newsDto = new NewsDto();
        newsDto.setId(id);
        newsDto.setTitle(news.getTitle());
        newsDto.setTypeId(news.getTypeId());
        newsDto.setAuthor(news.getAuthor());
        newsDto.setSummary(news.getSummary());
        newsDto.setTopFlagInt(news.getTopFlag());
        newsDto.setContent(newsContent.getContent());
        List<NewsReceiveDto> newsReceiveUserDtos = this.newsReceiveService.findUserByNewsId(id);
        List<NewsReceiveDto> newsReceiveOrgDtos = this.newsReceiveService.findOrgByNewsId(id);
        StringBuilder receiveNames = new StringBuilder();
        if (newsReceiveOrgDtos.size() > 0) {
            StringBuilder orgIds = new StringBuilder();
            for (i = 0; i < newsReceiveOrgDtos.size(); ++i) {
                if (i == newsReceiveOrgDtos.size() - 1) {
                    receiveNames.append(newsReceiveOrgDtos.get(i).getOrgname());
                    orgIds.append(newsReceiveOrgDtos.get(i).getSubjectId());
                    continue;
                }
                receiveNames.append(newsReceiveOrgDtos.get(i).getOrgname()).append(",");
                orgIds.append(newsReceiveOrgDtos.get(i).getSubjectId()).append(",");
            }
            newsDto.setReceiveOrgIds(orgIds.toString());
        }
        if (newsReceiveUserDtos.size() > 0) {
            if (newsReceiveOrgDtos.size() > 0) {
                receiveNames.append(",");
            }
            StringBuilder userIds = new StringBuilder();
            for (i = 0; i < newsReceiveUserDtos.size(); ++i) {
                if (i == newsReceiveUserDtos.size() - 1) {
                    receiveNames.append(newsReceiveUserDtos.get(i).getUsername());
                    userIds.append(newsReceiveUserDtos.get(i).getSubjectId());
                    continue;
                }
                receiveNames.append(newsReceiveUserDtos.get(i).getUsername()).append(",");
                userIds.append(newsReceiveUserDtos.get(i).getSubjectId()).append(",");
            }
            newsDto.setReceiveUserIds(userIds.toString());
        }
        newsDto.setReceiveNames(receiveNames.toString());
        return newsDto;
    }

    @Override
    public int removeNews(long id) {
        int res = ((News)((Object)((NewsMapper)this.baseMapper).selectById(Long.valueOf(id)))).getStatus();
        if (res != 2) {
            return ((NewsMapper)this.baseMapper).deleteById(Long.valueOf(id));
        }
        return -1;
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<News> findByName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return Optional.absent();
        }
        News news = ((NewsMapper)this.baseMapper).selectByName(name);
        if (news == null) {
            return Optional.absent();
        }
        return Optional.of((Object)((Object)news));
    }

    @Override
    public boolean addNews(News news) {
        news.setCreateTime(DateUtil.unixTime());
        news.setDeleteFlag(0);
        return ((NewsMapper)this.baseMapper).insert((Object)news) == 1;
    }

    @Override
    public boolean updateNews(News news) {
        news.setUpdateTime(DateUtil.unixTime());
        return ((NewsMapper)this.baseMapper).updateById((Object)news) == 1;
    }

    @Override
    @Transactional(readOnly=true)
    public void searchByPagination(Page<NewsDto> requestPage, NewsQuery query) {
        List<NewsDto> newsDtos = ((NewsMapper)this.baseMapper).searchByPagination(requestPage, query);
        requestPage.setRecords(newsDtos);
    }

    @Override
    @Transactional(readOnly=true)
    public Page<NewsDto> findByPagination(Page<NewsDto> pageResult, List<Sort.Order> orders) {
        List<NewsDto> newsDtos = ((NewsMapper)this.baseMapper).selectByPagination(pageResult, orders);
        pageResult.setRecords(newsDtos);
        return pageResult;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<NewsDto> selectByPageOrderByCreateTime(Page<NewsDto> page) {
        List<NewsDto> newsDtoPage = ((NewsMapper)this.baseMapper).selectByPageOrderByCreateTime(page);
        page.setRecords(newsDtoPage);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public Page<NewsVo> selectByRecUserTypePageOrderByCreateTime(Page<NewsVo> page, Long subjectId, Long type) {
        List<NewsVo> newsDtos = ((NewsMapper)this.baseMapper).selectByRecUserPageOrderByCreateTime(page, subjectId, NewsDto.InRelease, type);
        page.setRecords(newsDtos);
        return page;
    }

    @Override
    public List<NewsVo> findByRecUserStatusPageForHome(Long subjectId, Short status) {
        return ((NewsMapper)this.baseMapper).findByRecUserStatusPageForHome(subjectId, status);
    }

    @Override
    public NewsDetailVo findNewsDetail(Long id) {
        return ((NewsMapper)this.baseMapper).findNewsDetail(id);
    }
}

